#import "AqContentViewController.h"
#import "AqDrawerStatsTableView.h"
#import "Profile.h"


@implementation AqDrawerStatsTableView

/* Initialization */

    + (id) instance; {
        return [AqDrawerController instance]->statsView;
    }
    
    - (void) awakeFromNib; {
        [super awakeFromNib];
        [self setRowHeight: 25];
    }
    

#pragma mark -
/* Custom Overrides */

    - (int) numberOfRows; {
        return 3;
    }
    
    - (int) numberOfColumns; {
        return 1;
    }


#pragma mark -
/* Cell Accessors */

    #define self [AqDrawerStatsTableView instance]
    
    + (AqDrawerStatsCell*) networkCell; {
        return [[[self tableColumns] objectAtIndex: 0] dataCellForRow: 0];
    }
    
    + (AqDrawerStatsCell*) downloadsCell; {
        return [[[self tableColumns] objectAtIndex: 0] dataCellForRow: 1];
    }
    
    + (AqDrawerStatsCell*) uploadsCell; {
        return [[[self tableColumns] objectAtIndex: 0] dataCellForRow: 2];
    }

    + (void) redrawNetworkCell; {
        [self setNeedsDisplayInRect: [self rectOfRow: 0]];
    }
    
    + (void) redrawDownloadsCell; {
        [self setNeedsDisplayInRect: [self rectOfRow: 1]];
    }
    
    + (void) redrawUploadsCell; {
        [self setNeedsDisplayInRect: [self rectOfRow: 2]];
    }
    
    #undef self


#pragma mark -
/* Draw override */
        
    - (void) drawRect: (NSRect) rect; 
    {
        int i, count;
        float dy = _rowHeight + 2;
        int dwColorIndex;
        
        /* draw background */
            
            [white set];
            NSRectFill(rect);
    
        /* if resizing */

            #if 1
            NSSize size = [cache size];
            if ([self inLiveResize] && cache && size.width == rect.size.width && size.height >= rect.size.height) {
                [cache drawAtPoint: [self frame].origin fromRect: NSZeroRect operation: NSCompositeCopy fraction: 1.0];
                return;
            } else {
                [cache release];
                cache = nil;
            }
            #endif
            
        /* draw rows */
        
            i = floor(rect.origin.y/dy);
            count = MIN([self numberOfRows], ceil((rect.origin.y + rect.size.height)/dy));
            
            BOOL hasComputedFirstResponder = NO;
            BOOL isFirstResponder = NO;

            for (; i<count; i++) 
            {
                NSRect rowRect = [self rectOfRow: i];
                
                /* draw background, if necessary */
                if ( [self isRowSelected: i] ) {

                    if ( !hasComputedFirstResponder ) {

                        isFirstResponder = [[self window] firstResponder] == self && [[self window] isKeyWindow];
                        hasComputedFirstResponder = YES;

                    }

                    

                    dwColorIndex = kDWColorAlternateIndex;
                    
                    float r, g, b, a, r2, g2, b2, a2;
                    float rdiff, gdiff, bdiff, adiff;
                    int index = rowRect.size.height - 2;
                    
                    if (isFirstResponder) {
                        r = 0.13; g = 0.61; b = 0.89; a = 1.0;
                        r2 = 0.0; g2 = 0.39; b2 = 0.8; a2 = 1.0;
                    } else {
                        r = 0.585; g = 0.585; b = 0.585; a = 1.0;
                        r2 = 0.42; g2 = 0.42; b2 = 0.42; a2 = 1.0;
                    }
                    rdiff = (r2 - r)/index; gdiff = (g2 - g)/index; bdiff = (b2 - b)/index; adiff = (a2 - a)/index;

                    
                    [[NSColor colorWithDeviceRed:r2 green:g2 blue:b2 alpha:a2] set];
                    
                    NSRectFill(rowRect);
                    
                    NSRect t1, t2, t3;
                    
                    t1 = rowRect;
                    
                    if (i) {
                        t1.origin.y += 1;
                        t1.size.height -= 2;
                    } else {
                        t1.size.height -= 1;
                    }
                
                    int count;
                    for (count = 0; count < index; count++) {
                        NSDivideRect ( t1, &t2, &t3, 1.0, NSMinYEdge);
                        [[NSColor colorWithDeviceRed:r green:g blue:b alpha:a] set];
                        NSRectFillUsingOperation(t2, NSCompositeSourceOver);
                        r += rdiff;
                        g += gdiff;
                        b += bdiff;
                        a += adiff;
                        t1 = t3;
                    }
                    
                } else {

                    dwColorIndex = kDWColorWhiteIndex;

                }
                
                /* draw the row */
                    
                    DWTableCell* cell = [firstColumn dataCellForRow: i];
                    cell->dwColorIndex = dwColorIndex;
                    [cell drawWithFrame: rowRect inView: self];
            }
            
        /* if resizing */
            
            #if 1
            if ([self inLiveResize]) {
                cache = [[NSImage alloc] initWithSize: rect.size];
                [cache addRepresentation: [[[NSBitmapImageRep alloc] initWithFocusedViewRect: rect] autorelease]];
                [cache setFlipped: YES];
            }
            #endif
    }
    
    - (void) leftKeyPressed; {
        id theView = [AqContentViewController instance]->currentView;
        id tableView = [theView documentView];
        if ([tableView selectedRow] < 0) [tableView selectRow: 0 byExtendingSelection: NO];
        [[self window] makeFirstResponder: theView];
    }

    - (void) rightKeyPressed; {
        [self leftKeyPressed];
    }

@end