#import "AqDrawerStatsCell.h"
#import "DWCachedImage.h"
#import "NSImageExtensions.h"
#import "NSStringExtensions.h"
#import "Profile.h"


@implementation AqDrawerStatsCell

/* Text Attributes */

    + (id) primaryAttributes; {
        static id attributes = nil;
        if (!attributes)
            attributes = [[NSDictionary alloc] initWithObjectsAndKeys: [NSFont boldSystemFontOfSize: 11], NSFontAttributeName, [NSColor blackColor], NSForegroundColorAttributeName, nil];
        return attributes;
    }
    
    + (id) secondaryAttributes; {
        static id attributes = nil;
        if (!attributes)
            attributes = [[NSDictionary alloc] initWithObjectsAndKeys: [NSFont systemFontOfSize: 9], NSFontAttributeName, [NSColor grayColor], NSForegroundColorAttributeName, nil];
        return attributes;
    }


/* Copying */
    
    - (id) copyWithZone: (NSZone*) theZone; {
        return [self retain];
    }


/* Drawing */

    #define kAqDrawerStatsCellLeftTextMargin 24

    - (void) drawWithFrame: (NSRect) frame inView: (id) view;
    {
        NSSize imageSize = {11, 11};
        id theString;
        NSRect theRect = frame;
        
        /* Setup points */

            NSPoint imagePoint = (NSPoint){
                (kAqDrawerStatsCellLeftTextMargin-imageSize.width)/2 + 0.5,
                frame.origin.y + 7
            };
            NSPoint primaryPoint = (NSPoint){
                frame.origin.x + kAqDrawerStatsCellLeftTextMargin,
                frame.origin.y + 1
            };
            NSPoint secondaryPoint = (NSPoint){
                frame.origin.x + kAqDrawerStatsCellLeftTextMargin,
                frame.origin.y + 13
            };
        
        /* image */
        
            id image = (dwColorIndex == kDWColorAlternateIndex) ? alternateImage : primaryImage;
            [image drawAtPoint: imagePoint withBackgroundColorIndex: kDWColorWhiteIndex];
            
        /* primary */
        
            theRect.origin = primaryPoint;
            theString = primary;

            if (dwColorIndex == kDWColorAlternateIndex) {
                [theString setAlternateColor: [DWColor whiteColor]];
                theString = [theString alternateString];
            }

            [theString drawInRect: theRect centered: NO];
        
        /* secondary */
        
            theRect.origin = secondaryPoint;
            theString = secondary;

            if (dwColorIndex == kDWColorAlternateIndex) {
                [theString setAlternateColor: [DWColor whiteColorBlendedWithAlternate]];
                theString = [theString alternateString];
            }

            [theString drawInRect: theRect centered: NO];
    }
    

/* set... */

    - (void) setPrimaryImage: (NSImage*) theImage; {
        [primaryImage release];
        primaryImage = [[DWCachedImage alloc] initWithImage: theImage];
        [primaryImage setDrawsBackground: NO];
    }
    
    - (void) setAlternateImage: (NSImage*) theImage; {
        [alternateImage release];
        alternateImage = [[DWCachedImage alloc] initWithImage: theImage];
        [alternateImage setDrawsBackground: NO];
    }

    - (void) setPrimary: (NSString*) theString; {
        [primary release];
        primary = DWTableStringCreate(theString, [AqDrawerStatsCell primaryAttributes]);
        [primary setStyle: DWCollapseNone];
    }

    - (void) setSecondary: (NSString*) theString; {
        [secondary release];
        secondary = DWTableStringCreateCached(theString, [AqDrawerStatsCell secondaryAttributes]);
        [secondary setStyle: DWCollapseNone];
    }
    
@end


/* Particular Implementations */

@implementation AqDrawerStatsNetworkCell

    #define NETWORK NSLocalizedStringFromTable(@"Network", @"Drawer", @"Drawer cell")
    #define CONNECTING NSLocalizedStringFromTable(@"connecting...", @"NetworkCell", @"When the network is just connecting")
    
    - (id) init; {
        self = [super init];
        [self setPrimary: NETWORK];
        [self setSecondary: CONNECTING];
        [self setPrimaryImage: [NSImage imageNamed: @"AcqNetworkGray"]];
        [self setAlternateImage: [NSImage imageNamed: @"AcqNetworkWhite"]];
        return self;
    }
    
@end


@implementation AqDrawerStatsDownloadsCell

    #define DOWNLOADS NSLocalizedStringFromTable(@"Downloads", @"Drawer", @"Drawer cell")
    
    - (id) init; {
        self = [super init];
        [self setPrimary: DOWNLOADS];
        [self setPrimaryImage: [NSImage imageNamed: @"AcqDownloadGray"]];
        [self setAlternateImage: [NSImage imageNamed: @"AcqDownloadWhite"]];
        return self;
    }

@end


@implementation AqDrawerStatsUploadsCell

    #define UPLOADS NSLocalizedStringFromTable(@"Uploads", @"Drawer", @"Drawer cell")

    - (id) init; {
        self = [super init];
        [self setPrimary: UPLOADS];
        [self setPrimaryImage: [NSImage imageNamed: @"AcqUploadGray"]];
        [self setAlternateImage: [NSImage imageNamed: @"AcqUploadWhite"]];
        return self;
    }

@end