/*
** AqQueryTableView(Actions)
** 
** CHANGES:
** 0.1  (pozytron) Changed Link Destination for Amazon
** 0.22 (pozytron) Added "Remove All Searches" item to context menu
*/

#import "AqBrowseHostQuery.h"
#import "AqContentViewController.h"
#import "AqQueryTableView(Actions).h"
#import "AqQueryDataSource(Actions).h"
#import "AqURLHandler.h"
#import "NSMenuExtensions.h"


@implementation AqDrawerQueryTableView (Actions)

/* Contextual Menu */

    #define START NSLocalizedStringFromTable(@"Start Query", @"DrawerContextMenu", @"")
    #define STOP NSLocalizedStringFromTable(@"Stop Query", @"DrawerContextMenu", @"")
    #define CLEARSTART NSLocalizedStringFromTable(@"Clear All Results and Start Query", @"DrawerContextMenu", @"")
    #define CLEAR NSLocalizedStringFromTable(@"Clear All Results", @"DrawerContextMenu", @"")
    #define REMOVEALL NSLocalizedStringFromTable(@"Remove All Searches", @"DrawerContextMenu", @"")
    #define REMOVE NSLocalizedStringFromTable(@"Remove", @"DrawerContextMenu", @"")
    #define SGOOGLE NSLocalizedStringFromTable(@"Search Google", @"DrawerContextMenu", @"")
    #define SAMAZON NSLocalizedStringFromTable(@"Search Amazon.com", @"DrawerContextMenu", @"")

    - (id) menuForQuery; {
        NSMenu* m = [[[NSMenu alloc] initWithTitle: @"nil"] autorelease];
        BOOL isActive = [qc isActiveAtIndex: [self selectedRow]];
        id query = [qc queryAtIndex: [self selectedRow]];

        if (!isActive) [m addItemWithTitle: START action: @selector(startQuery:) target: self];
        if (isActive)  [m addItemWithTitle: STOP action: @selector(stopQuery:) target: self];
        [m addItemWithTitle: REMOVE action: @selector(removeQuery:) target: self];
        [m addItemWithTitle: REMOVEALL action: @selector(removeAllQueries:) target: self];
        [m addSeparator];
        if (!isActive && [query count]) [m addItemWithTitle: CLEARSTART action: @selector(clearAllResultsAndStartQuery:) target: self];
        if (!isActive && [query count]) [m addItemWithTitle: CLEAR action: @selector(clearAllResults:) target: self];
        if (!isActive && [query count]) [m addSeparator];
        [m addItemWithTitle:  SGOOGLE action: @selector(searchGoogle:) target: self];
        [m addItemWithTitle: SAMAZON action: @selector(searchAmazon:) target: self];

        return m;
    }

    #define COPY NSLocalizedStringFromTable(@"Copy Browse URL", @"DrawerContextMenu", @"")
    #define KEEP NSLocalizedStringFromTable(@"Keep In Drawer", @"DrawerContextMenu", @"")

    - (id) menuForBrowseQuery; {
        NSMenu* m = [[[NSMenu alloc] initWithTitle: @"nil"] autorelease];
        [m addItemWithTitle: COPY action: @selector(copyBrowseURL:) target: self];
        [m addItemWithTitle: REMOVE action: @selector(removeQuery:) target: self];
        [m addItemWithTitle: REMOVEALL action: @selector(removeAllQueries:) target: self];
        if (![AqQC queryAtIndex: [self selectedRow]]->keepInDrawer) [m addItemWithTitle: KEEP action: @selector(keepInDrawer:) target: self];
        return m;
    }

    - (id) menuForEvent: (NSEvent*) theEvent; {
        int row = [self rowAtPoint: [theEvent locationInView: self]];
        if ((row < 0)) return nil;

        [self selectRow: row byExtendingSelection: NO];
        [[self window] makeFirstResponder: self];

        if ([[qc queryAtIndex: row] isKindOfClass: [AqBrowseHostQuery class]]) {
            return [self menuForBrowseQuery];
        } else {
            return [self menuForQuery];
        }
    }
    
    - (void) startQuery: (id) sender; {
        [[AqDrawerController instance] startSelected: nil];
    }

    - (void) stopQuery: (id) sender; {
        [[AqDrawerController instance] stopSelected: nil];
    }
    
    - (void) clearAllResultsAndStartQuery: (id) sender; {
        int row = [self selectedRow];
        [[AqDrawerController instance] setActive: YES atIndex: row];
        [[qc sourceAtIndex: row] removeAll: nil];
    }

    - (void) clearAllResults: (id) sender; {
        int row = [self selectedRow];
        [[qc sourceAtIndex: row] removeAll: nil];
    }

    - (void) removeQuery: (id) sender; {
        [[AqDrawerController instance] deleteSelectedQueries: nil];
    }
    
    - (void) removeAllQueries: (id) sender; {
        [[AqDrawerController instance] deleteAllQueries: nil];
    }
        
    - (void) searchGoogle: (id) sender; {
        id query = [[[qc stringAtIndex: [self selectedRow]] componentsSeparatedByString: @" "] componentsJoinedByString: @"+"];
        [[NSWorkspace sharedWorkspace] openURL: [NSURL URLWithString: [NSString stringWithFormat: @"http://google.com/search?q=%@", query]]];
    }
    
    - (void) searchAmazon: (id) sender; {
        id query = [[[qc stringAtIndex: [self selectedRow]] componentsSeparatedByString: @" "] componentsJoinedByString: @"+"];
        [[NSWorkspace sharedWorkspace] openURL: [NSURL URLWithString: [NSString stringWithFormat: @"http://www.amazon.com/exec/obidos/external-search?mode=blended&keyword=%@", query]]];
    }
    
    - (void) copyBrowseURL: (id) sender; {
        id theAddress = [qc stringAtIndex: [self selectedRow]];
        [[NSPasteboard generalPasteboard] declareTypes: [NSArray arrayWithObject: NSStringPboardType] owner: self];
        [[NSPasteboard generalPasteboard] setString: [AqURLHandler browseURLForAddress: theAddress] forType: NSStringPboardType];
    }
    
    - (void) keepInDrawer: (id) sender; {
        [qc queryAtIndex: [self selectedRow]]->keepInDrawer = YES;
    }
    

#pragma mark -
/* Keys */

    - (NSView*) nextValidKeyView; {
        id currentView = [[AqContentViewController instance] currentView];
        if ([currentView isKindOfClass: [NSSplitView class]]) {
            return [[[currentView subviews] objectAtIndex: 0] firstView];
        } else {
            return [AqDrawerController instance]->statsView;
        }
    }

    - (NSView*) previousValidKeyView; {
        return [[AqContentViewController instance] currentToolbarDelegate]->searchView;
    }

    - (void) enterKeyPressed; {
        [[AqDrawerController instance] startSelected: nil];
    }
    
    - (void) leftKeyPressed; {
        [[self window] makeFirstResponder: [AqContentViewController instance]->currentView];
    }
    
    - (void) rightKeyPressed; {
        [[self window] makeFirstResponder: [AqContentViewController instance]->currentView];
    }
    
    - (void) spaceKeyPressed; {
        [[AqDrawerController instance] toggleSelected: nil];
    }
    
    - (void) deleteKeyPressed; {
        [[AqDrawerController instance] shouldDeleteSelection];
    }

@end