/*
** AqDrawerQueryTableView
** 
** CHANGES:
** 0.23 (pozytron) Made more "realistic" hyperlink
*/

#import "AqDrawerQueryTableView.h"
#import "AqQueryCell.h"
#import "DWUtil.h"

@implementation AqDrawerQueryTableView

/* Awake */

    - (void) awakeFromNib; {
        [super awakeFromNib];
        [self setRowHeight: 23];
        qc = [AqQueryController instance];
    }
    
            
#pragma mark -
/* Overrides */


    - (int) numberOfRows; {
        return [qc count];
    }
    
    - (int) numberOfColumns; {
        return 1;
    }
    
    - (void) addOrRemoveScroller; {
        id scrollView = [self enclosingScrollView];
        BOOL shouldHaveVerticalScroller = ((float)[self numberOfRows] * [self rowHeight] > [scrollView documentVisibleRect].size.height);
        if (shouldHaveVerticalScroller ^ [scrollView hasVerticalScroller]) {
            [scrollView setHasVerticalScroller: shouldHaveVerticalScroller];
            [[scrollView contentView] viewFrameChanged: nil];
        }

    }
    
    - (void) tile; {
        [super tile];
        [self addOrRemoveScroller];
    }


#pragma mark -
/* Draw override */
    
    - (void) drawRect: (NSRect) rect; 
    {
        int i, count;
        int dwColorIndex;

        float dy = _rowHeight + 2.0f;

        /* draw background */

            [white set];

            NSRectFill(rect);

        /* draw rows */
        
            i = floor(rect.origin.y/dy);
            count = MIN([self numberOfRows], ceil((rect.origin.y + rect.size.height)/dy));
            
            BOOL hasComputedFirstResponder = NO;
            BOOL isFirstResponder = NO;

            for (; i<count; i++) 
            {
                NSRect rowRect = [self rectOfRow: i];
                rowRect.size.height -= 0.5;

                rowRect.size.width = MIN(rowRect.size.width, rect.size.width+3);
                
                /* draw background, if necessary */
                if ( [self isRowSelected: i] ) {

                    if ( !hasComputedFirstResponder ) {

                        isFirstResponder = [[self window] firstResponder] == self && [[self window] isKeyWindow];
                        hasComputedFirstResponder = YES;

                    }

                    dwColorIndex = kDWColorAlternateIndex;
                    
                    float r, g, b, a, r2, g2, b2, a2;
                    float rdiff, gdiff, bdiff, adiff;
                    int index = rowRect.size.height - 2;
                    
                    if (isFirstResponder) {
                        r = 0.13; g = 0.61; b = 0.89; a = 1.0;
                        r2 = 0.0; g2 = 0.39; b2 = 0.8; a2 = 1.0;
                    } else {
                        r = 0.585; g = 0.585; b = 0.585; a = 1.0;
                        r2 = 0.42; g2 = 0.42; b2 = 0.42; a2 = 1.0;
                    }
                    rdiff = (r2 - r)/index; gdiff = (g2 - g)/index; bdiff = (b2 - b)/index; adiff = (a2 - a)/index;

                    
                    [[NSColor colorWithDeviceRed:r2 green:g2 blue:b2 alpha:a2] set];
                    
                    NSRectFill(rowRect);

                    NSRect t1, t2, t3;
                    t1 = rowRect;
                    
                    if (i) {
                        t1.origin.y += 1;
                        t1.size.height -= 2;
                    } else {
                        t1.size.height -= 1;
                    }
                    
                    int i;                
                    for ( i = 0; i < index; i++ )
                    {
                        NSDivideRect ( t1, &t2, &t3, 1.0, NSMinYEdge);
                        [[NSColor colorWithDeviceRed:r green:g blue:b alpha:a] set];
                        NSRectFillUsingOperation(t2, NSCompositeSourceOver);
                        r += rdiff;
                        g += gdiff;
                        b += bdiff;
                        a += adiff;
                        t1 = t3;
                    }

                } else {

                    dwColorIndex = kDWColorWhiteIndex;

                }
                
                /* draw the row */
                    
                    DWTableCell* cell = [qc cellAtIndex: i];
                    cell->dwColorIndex = dwColorIndex;
                    [cell drawWithFrame: rowRect inView: self];
            }
    }

@end