#import "DWObject.h"
#import "AqQueryController.h"


@interface AqDrawerController : DWObject 
{
    @public
    
    /* UI */

        id window;
        id drawerView;
        id contentView;
        id queryView;
        id statsView;
        id splitView;
        
        id defaultView;
        id toolbarDelegate;
    
    /* Tracking */
    
        int mouseOverRow;
        id trackingTags;
        BOOL shouldResetTrackingRects;
    
    /* Local */
    
        AqQueryController* qc;
        
    /* Stats view */
        
        int negotiating;
        
        NSRect lastLeftFrame, lastRightFrame;
        bool collapsed;
        
    /* Status Bar */

	id statusBar;
        id statusBarProgress;
        unsigned int downloadForStatus;

}

+ (AqDrawerController*) instance;

- (void) toggleSidebar;
- (void) trigger: (id) sender;
- (void) searchFromMenu: (id) sender;
- (void) textQuery: (NSString*) query;

- (IBAction) deleteSelectedQueries: (id) sender;
- (IBAction) deleteAllQueries: (id) sender;
- (void) shouldDeleteSelection; 
- (void) resetAllFileCounts;

- (BOOL) doMouseUp: (NSEvent*) event;
- (BOOL) doMouseDown: (NSEvent*) event;

- (IBAction) mainWindow: (id) sender;

- (IBAction) command1: (id) sender;
- (IBAction) command2: (id) sender;
- (IBAction) command3: (id) sender;
- (IBAction) command4: (id) sender;

- (IBAction) startSelected: (id) sender;
- (IBAction) stopSelected: (id) sender;
- (IBAction) toggleSelected: (id) sender;

- (void) setActive: (BOOL) active atIndex: (unsigned) index;

- (void) queryViewSelectionDidChange: (id) sender;

- (void) collapseSidebar;
- (void) uncollapseSidebar;

- (void) writeStatusBar: (NSString*) theStr;
- (void) redrawStatusBar;
+ (void) redrawStatusBar;

- (unsigned int) downloadForStatus;
- (void) setDownloadForStatus: (int) theVal;
- (void) showStatusDownload: (int) theDownload;
+ (unsigned int) downloadForStatus;
+ (void) setDownloadForStatus: (int) theVal;
+ (void) setDownloadForStatusFromMenu: (id) theVal;
+ (void) showStatusDownload: (int) theDownload;
+ (float) statusDownloadPercent;

@end