#import "DWMetalBox.h"


@implementation DWMetalBox

static id g1 = nil;
static id g2 = nil;
static id g3 = nil;
static id g4 = nil;

- (void) awakeFromNib; 
{
    [self setPostsFrameChangedNotifications: NO];
    [self setPostsBoundsChangedNotifications: NO];

    if (!g1) {
        g1 = [[NSColor colorWithCalibratedRed: 0.400000 green: 0.400000 blue: 0.400000 alpha:1.0] retain];
        g2 = [[NSColor colorWithCalibratedRed: 0.576471 green: 0.576471 blue: 0.576471 alpha:1.0] retain];
        g3 = [[NSColor colorWithCalibratedRed: 0.878431 green: 0.878431 blue: 0.878431 alpha:1.0] retain];
        g4 = [[NSColor colorWithCalibratedRed: 0.941176 green: 0.941176 blue: 0.941176 alpha:1.0] retain];
    }
    
    shouldDisplay = YES;
}

- (void) setShouldDisplay: (BOOL) theValue; {
    shouldDisplay = theValue;
}

- (void) drawRect: (NSRect) theRect; 
{
    if (!shouldDisplay) return;
    
    theRect = [self bounds];
    
    [g1 set];
    [NSBezierPath strokeRect: NSInsetRect(theRect, 1.5, 1.5)];
    
    NSRect r = (NSRect){
        {theRect.origin.x, theRect.origin.y + 1},
        {1, theRect.size.height - 2}
    };
    
    [g3 set];
    NSRectFill(r);

    r.origin.x += theRect.size.width - 1;
    NSRectFill(r);

    [g4 set];
    r = (NSRect){
        {theRect.origin.x + 1, theRect.origin.y},
        {theRect.size.width - 2, 1}
    };
    NSRectFill(r);

    [g2 set];
    
    r = (NSRect){
        {theRect.origin.x + 1, theRect.origin.y + theRect.size.height -1},
        {theRect.size.width - 2, 1}
    };
    NSRectFill(r);
}

@end