#import "DWCachedString.h"
#import "DWText.h"
#import "DWTimeInterval.h"
#import "NSDateExtensions.h"


@implementation DWTimeInterval

/* Initialization */
    
    - (id) initWithTimeInterval: (NSTimeInterval) theInterval; {
        value = theInterval;
        return self;
    }

    - (id) copyWithZone: (id) zone; {
        return [self retain];
    }


/* API */

    - (void) setTimeInterval: (NSTimeInterval) theInterval; {
        value = theInterval;
        [description release];
        description = nil;
    }

    - (void) incrementByOneSecond; {
        value++;
        [description release];
        description = nil;
    }

    - (float) floatValue; {
        return value;
    }
    
    - (NSString*) description; {
        if (!description) description = [[NSDate stringFromTimeInterval: value] retain];
        return description;
    }


/* Image */

    - (id) image; 
    {
        /* initialize global image cache */

            static id imageCache = nil;
            if (!imageCache) imageCache = [[NSMutableDictionary alloc] init];
        
        /* cache this particular value, if necessary */

            id theString = [self description];
            id cachedImage = nil;
    
            if (!(cachedImage = [imageCache objectForKey: theString])) 
            {
                cachedImage = [DWCachedString cachedImageWithString: theString attributes: [DWText smallTextAttributes]];
                [imageCache setObject: cachedImage forKey: theString];
            }

        return cachedImage;
    }

@end