#import "DWTableString.h"


@interface DWSISize : NSObject
{
    @public
    double value;
    int displayPrecision;
    BOOL showsSIUnits;
    
    int thousand;
    id postfix;
    id zeroValue;
    int minimumMagnitude;
    
    id image;
    id tableString;
    id description;
}

+ (id) sizeWithValue: (double) val;
- (id) initWithValue: (double) val; 

- (void) setValue: (double) val;

- (void) setDisplayPrecision: (int) digits;
- (void) setShowsSIUnits: (BOOL) toSet;
- (void) setPostfix: (id) theValue;
- (void) setZeroValue: (id) theValue;
- (void) setMinimumMagnitude: (int) theValue;

- (double) value;

- (DWTableString*) tableString;
- (NSImage*) image;

@end