/**
 * Acquisition
 * http://www.xlife.org/
 *
 * Copyright (c) 2002-2003 David Keiichi Watanabe
 * davew@xlife.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#import "Profile.h"

static NSString* name = @"";
static NSDate* startTime = nil;

static float total[] = {0,0,0,0,0,0,0,0};
static int   n[]     = {0,0,0,0,0,0,0,0};

@implementation Profile

+ (void) start; {
    [startTime release];
    startTime = [[NSDate alloc] init];

    [name release];
    name = @"";
}

+ (void) startWithString: (NSString*) s; {
    [Profile start];
    name = [s retain];
}

+ (void) end; {
    [Profile endWithIndex: 0];
}

+ (void) endWithIndex: (int) index; {
    float f = -1 * [startTime timeIntervalSinceNow];
    n[index]++; total[index] += f;
    NSLog(@"[P]: %@, %f (%f av)", name, f, total[index]/n[index]);
}

@end