#import "DWRectUtil.h"


/* ensure lines fall at pixel positions, rather than in between (fuzzy lines results) */
NSRect DWPixelateRect(NSRect rect)
{
    rect.origin.x = 0.5 + (float)floor(rect.origin.x);
    rect.origin.y = 0.5 + (float)floor(rect.origin.y);

    rect.size.width = floor(rect.size.width);
    rect.size.height = floor(rect.size.height);
    
    return rect; 
}


NSRect DWCenteredRectInRect(NSRect a, NSRect b) 
{
    NSRect result = a;
    
    result.origin.x = ceil(b.origin.x + (b.size.width - a.size.width)/2);
    result.origin.y = ceil(b.origin.y + (b.size.height - a.size.height)/2);

    return result;
}


NSRect DWCenteredRectOfSizeInRect(NSSize toCenter, NSRect inRect) {
    return DWCenteredRectInRect((NSRect){{0,0}, {toCenter.width,toCenter.height}}, inRect);
}