#import "DWObject.h"

//#define INIT_DEBUG
//#define DEALLOC_DEBUG
//#define AWAKE_DEBUG
//#define LAUNCH_DEBUG
//#define TERMINATE_DEBUG
//#define DEFAULTS_DEBUG


@implementation DWObject

    - (void) awakeFromNib; 
    {
        #ifdef AWAKE_DEBUG
        NSLog(@"*^^* awake: %@", self);
        #endif
        
        [[NSNotificationCenter defaultCenter] addObserver: self selector: @selector(applicationDidFinishLaunching:) name: NSApplicationDidFinishLaunchingNotification object: NSApp];
    }

    - (id) init; 
    {
        defaultsDidChangeListen = NO;
        self = [super init];
        
        #ifdef INIT_DEBUG
        NSLog(@"*++* init: %@", self);
        #endif
        
        [self listenForNotification: NSApplicationWillFinishLaunchingNotification selector: @selector(applicationWillFinishLaunching:)];
        [self listenForNotification: NSApplicationDidFinishLaunchingNotification selector: @selector(applicationDidFinishLaunching:)];
        /* lw shutdown problems ensue */
        //[self listenForNotification: NSApplicationWillTerminateNotification selector: @selector(applicationWillTerminate:)];
        
        if (defaultsDidChangeListen) 
            [self listenForNotification: NSUserDefaultsDidChangeNotification selector: @selector(defaultsDidChange:)];

        [self initDefaults];

        return self;
    }

    - (void) dealloc; 
    {
        #ifdef DEALLOC_DEBUG
        NSLog(@"*--* dealloc: %@", self);
        #endif

        [[NSNotificationCenter defaultCenter] removeObserver: self name: NSApplicationDidFinishLaunchingNotification object: NSApp];
        [super dealloc];
    }
    

/* applicationWillFinishLaunching */

    - (void) applicationWillFinishLaunching: (id) sender; {
        [self applicationWillFinishLaunching];
    }
    
    - (void) applicationWillFinishLaunching; 
    {
        #ifdef LAUNCH_DEBUG
        NSLog(@"*||* willLaunch: %@", self);
        #endif
    }


/* applicationDidFinishLaunching */

    - (void) applicationDidFinishLaunching: (id) sender; 
    {
        [self applicationDidFinishLaunching];
        //[[NSNotificationCenter defaultCenter] removeObserver: self name: NSApplicationDidFinishLaunchingNotification object: NSApp];
    }
    
    - (void) applicationDidFinishLaunching; 
    {	
        #ifdef LAUNCH_DEBUG
        NSLog(@"*>>* didLaunch: %@", self);
        #endif
    }


/* applicationWillTerminate */

    - (void) applicationWillTerminate: (id) sender; {
        [self applicationWillTerminate];
    }

    - (void) applicationWillTerminate; 
    {
        #ifdef LAUNCH_DEBUG
        NSLog(@"*xx* willTerminate: %@", self);
        #endif
    }
 
       
/* defaultsDidChange */

    - (void) defaultsDidChange: (id) sender; {
        [self defaultsDidChange];
    }
    
    - (void) defaultsDidChange; {
        #ifdef DEFAULTS_DEBUG
        NSLog(@"*$$* defaultsDidChange: %@", self);
        #endif
    }


/* initDefaults */

    - (void) initDefaults; {
    }

@end