#import "DWColor.h"
#import "DWMultiLevelCell.h"
#import "DWText.h"
#import "NSAttributedStringExtensions.h"


@implementation DWMultiLevelCell

/* Draw */

    - (void) drawInteriorWithFrame: (NSRect) frame inView: (NSView*) view; 
    {
        id theString;
        NSRect theRect = frame;
        theRect.size.width -= 6;
        
        /* primary */
        
            theRect.origin = frame.origin;
            theRect.origin.y += 3;
            theRect.origin.x += 5;
            
            theString = primary;
            if (dwColorIndex == kDWColorAlternateIndex) {
                [theString setAlternateColor: [DWColor whiteColor]];
                theString = [theString alternateString];
            }

            [theString setStyle: DWCollapseCenter];
            [theString drawInRect: theRect centered: centerAligned];
                        
        /* secondary */
        
            theRect.origin = frame.origin;
            theRect.origin.y += 18;
            theRect.origin.x += 5;
            
            theString = secondary;
            if (dwColorIndex == kDWColorAlternateIndex) {
                [theString setAlternateColor: [DWColor whiteColorBlendedWithAlternate]];
                theString = [theString alternateString];
            }

            [theString setStyle: DWCollapseCenter];
            [theString drawInRect: theRect centered: centerAligned];
    }


/* set... */

    - (void) setPrimary: (DWConfinedString*) theString; {
        [primary release];
        primary = [theString retain];
    }
    
    - (void) setSecondary: (DWConfinedString*) theString; {
        [secondary release];
        secondary = [theString retain];
    }

    - (void) setCenterAligned: (BOOL) theValue; {
        centerAligned = theValue;
    }

@end