#import <Cocoa/Cocoa.h>


typedef enum {
    DWCollapseRight,
    DWCollapseCenter,
    DWCollapseNone
} DWCollapsingStyle;


@interface DWConfinedString : NSObject 
{
    @public
    NSAttributedString* string;
    DWCollapsingStyle style;

    @private
    BOOL hasCachedMetrics;
    int nglyphs;
    float* metrics;
    float totalWidth;

    NSTextStorage*   textStorage;
    NSLayoutManager* layoutManager;
    NSTextContainer* textContainer;
}

- (id) initWithAttributedString: (NSAttributedString*) theString;
- (id) initWithString: (NSString*) theString attributes: (id) theAttributes;

- (void) setAttributedString: (NSAttributedString*) theString;
- (void) setString: (NSString*) theString;
- (void) setStyle: (DWCollapsingStyle) theStyle;

- (NSAttributedString*) attributedString;
- (NSString*) string;
- (float) totalWidth;

- (void) drawInRect: (NSRect) theRect;
- (void) drawInRect: (NSRect) theRect centered: (BOOL) isCentered;

@end