#import "DWTableColumn.h"
#import "DWTableObject.h"

#define DWRequired		1
#define DWDefault		2
#define DWCenterAligned 	4

#define DWStringSorted		8
#define DWFloatSorted		16
#define DWNotSortable		32

#define DWTableStringValue	64
#define DWIconValue		128
#define DWCachedImageValue	256
#define DWImageAccessor		512
#define DWTableCellValue	1024
#define DWMultiLevelCellValue	2048
#define DWNoIndicators          4096
#define DWSortAscendingFirst    8192


typedef struct {
    id identifier;
    id name;
    id shortName;
    id image;

    unsigned flags;

    SEL sel;
    SEL sortSel;

    id column;
    id cell;
    int minWidth;
    int maxWidth;

    SEL primary;
    SEL secondary;
    
    void* comparator;
} DWTableControllerAttributes;

int compare(id,id,id[]);


@interface DWTableController : NSResponder 
{
    @public
    id tableView;

    NSMutableArray* objects;
    NSMutableArray* columns;

    unsigned sequence;
    id selected;
    
    DWTableColumn* sortedColumn;
    BOOL sortedAscending;
    BOOL shouldSaveSortOrder;
}

- (void) setTableView: (id) theView; 

- (NSMutableArray*) objects;
- (unsigned) count;

- (void) addTableObject: (DWTableObject*) theObject;
- (void) setSequence: (DWTableObject*) theObject;
- (void) removeAllObjects;

- (id) objectAtRow: (int) index;
- (int) rowOfObject: (id) obj;

- (NSArray*) selectedObjects;
- (BOOL) selectObject: (id) obj byExtendingSelection: (BOOL) extend;
- (BOOL) selectObjects: (id) objs byExtendingSelection: (BOOL) extend;
- (void) saveSelectedObjects;
- (void) restoreSelectedObjects;

- (id) sortedValueOfObject: (id) obj forColumn: (id) column; 
- (void) sort;

- (void) addColumn: (DWTableControllerAttributes) attributes;

- (void) loadDefaults;
- (void) saveDefaults;

@end