#import "DWStripedTableView.h"
#import "DWTableHeaderView.h"

@class DWCustomizableCornerView;


@interface DWCustomizableTableView : DWStripedTableView 
{
    BOOL autosavesColumns;
    DWCustomizableCornerView* corner;
}

- (NSArray*) availableTableColumns;
- (BOOL) isColumnVisible: (id) column;

- (void) loadDefaultColumns;
- (void) loadColumnsFromPreferences;
- (void) saveColumnDefaultsIfNeeded: (id) sender; 

- (void) removeAllTableColumns;

- (NSMenu*) customizationMenuWithNullFirstElement: (BOOL) nullFirstElement;

@end



@protocol DWCustomizableTableViewDelegate

- (void) initColumns; 
- (NSArray*) defaultColumnsInTableView: (DWCustomizableTableView*) theTable;
- (NSArray*) columnsInTableView: (DWCustomizableTableView*) theTable;
- (BOOL) isColumn: (NSTableColumn*) col requiredInTableView: (DWCustomizableTableView*) theTable;

@end



@interface DWCustomizableTableHeaderView : DWTableHeaderView 
{
}
@end



@interface DWCustomizableCornerView: NSPopUpButton 
{
    DWCustomizableTableView* tableView;
}

- (void) setTableView: (id) view;

@end