/*
 ** DWColor
 ** 
 ** CHANGES:
 ** 0.21 (pozytron) Added grayColor30
 */

#import "DWColor.h"


@implementation DWColor

/* Indices */

    + (NSColor*) colorForIndex: (int) dwColorIndex; {
        switch (dwColorIndex) {
            case kDWColorWhiteIndex:
                return [DWColor whiteColor];
                break;
            case kDWColorLightBlueIndex:
                return [DWColor lightBlueColor];
                break;
            case kDWColorAlternateIndex:
                return [DWColor alternateSelectedControlColor];
                break;
            case kDWColorSecondaryIndex:
                return [DWColor secondarySelectedControlColor];
                break;
            default:
                return nil;
        }
    }

    + (int) indexForColor: (NSColor*) theColor; {
        if (theColor == [DWColor whiteColor])
            return kDWColorWhiteIndex;
        if (theColor == [DWColor lightBlueColor])
            return kDWColorLightBlueIndex;
        if (theColor == [DWColor alternateSelectedControlColor])
            return kDWColorAlternateIndex;
        if (theColor == [DWColor secondarySelectedControlColor])
            return kDWColorSecondaryIndex;
        return kDWColorWhiteIndex;
    }


/* Colors */

    + (NSColor*) whiteColor; {
        static id color = nil;
        if (!color) color = [[NSColor whiteColor] retain];
        return color;
    }

    + (NSColor*) grayColor30; {
        static id color = nil;
        if (!color) color = [[NSColor colorWithCalibratedRed: 0.300000 green: 0.300000 blue: 0.300000 alpha: 1.0] retain];
        return color;
    }

    + (NSColor*) grayColor; {
        static id color = nil;
        if (!color) color = [[NSColor grayColor] retain];
        return color;
    }

    + (NSColor*) grayColor80; {
        static id color = nil;
        if (!color) color = [[NSColor colorWithCalibratedRed: 0.800000 green: 0.800000 blue: 0.800000 alpha: 1.0] retain];
        return color;
    }

    + (NSColor*) blackColor; {
        static id color = nil;
        if (!color) color = [[NSColor blackColor] retain];
        return color;
    }
    
    + (NSColor*) lightBlueColor; {
        static id color = nil;
        if (!color) color = [[NSColor colorWithCalibratedRed: 0.929412 green: 0.952941 blue: 0.996078 alpha: 1.0] retain];
        return color;
    }

    + (NSColor*) alternateSelectedControlColor; {
        static id color = nil;
        if (!color) color = [[[NSColor alternateSelectedControlColor] colorUsingColorSpaceName: NSCalibratedRGBColorSpace] retain];
        return color;
    }
    
    + (NSColor*) secondarySelectedControlColor; {
        static id color = nil;
        if (!color) color = [[[NSColor secondarySelectedControlColor] colorUsingColorSpaceName: NSCalibratedRGBColorSpace] retain];
        return color;
    }

    + (NSColor*) whiteColorBlendedWithAlternate; {
        static id color = nil;
        if (!color) color = [[[NSColor whiteColor] blendedColorWithFraction: 0.3 ofColor: [DWColor alternateSelectedControlColor]] retain];
        return color;
    }

@end