#import "DWColor.h"


#define kDWNoCache        -1
#define kDWGeneralCache   0
#define kDWSizeCache      1
#define kDWIPCache        2
#define kDWTimeCache      3

#define kDWTotalCaches    4


@interface DWCachedString : NSObject 
{
    NSString* string;
    NSDictionary* attributes;
    
    id cachedImages[kDWColorTotalIndices];
    BOOL usesWhiteSilhouetteWhenAppropriate;
}

+ (id) cachedImageWithString: (NSString*) theString;
+ (id) cachedImageWithString: (NSString*) theString attributes: (id) theAttributes;
- (id) initWithString: (NSString*) theString;
- (id) initWithString: (NSString*) theString attributes: (id) theAttributes;

- (id) imageWithBackgroundColorIndex: (int) dwColorIndex;
- (void) drawAtPoint: (NSPoint) thePoint withBackgroundColorIndex: (int) dwColorIndex;

- (void) setUsesWhiteSilhouetteWhenAppropriate: (BOOL) value;
- (void) setString: (NSString*) theString attributes: (id) theAttributes;

- (id) string;

@end