#import "DWColor.h"


@interface DWCachedImage : NSObject 
{
    NSImage* originalImage;

    id cachedImages[kDWColorTotalIndices];
    BOOL usesWhiteSilhouetteWhenAppropriate;
    BOOL drawsBackground;
}

+ (id) cachedImageWithImage: (NSImage*) theImage;
- (id) initWithImage: (NSImage*) theImage;

- (id) imageWithBackgroundColorIndex: (int) dwColorIndex;
- (void) drawAtPoint: (NSPoint) thePoint withBackgroundColorIndex: (int) dwColorIndex;

- (void) setUsesWhiteSilhouetteWhenAppropriate: (BOOL) value;
- (void) setDrawsBackground: (BOOL) value;
- (void) setImage: (id) theImage;
- (NSImage*) originalImage;

@end