#import "NSUserDefaultsExtensions.h"


@implementation NSUserDefaults (Extensions)

/* NSSize */

    - (void) setSize: (NSSize) size forKey: (NSString*) key; 
    {
        id k1 = [key stringByAppendingString: @".width"];
        id k2 = [key stringByAppendingString: @".height"];
        
        [self setFloat: size.width forKey: k1];
        [self setFloat: size.height forKey: k2];
    }
    
    - (NSSize) sizeForKey: (NSString*) key; 
    {
        NSSize result;
        id k1 = [key stringByAppendingString: @".width"];
        id k2 = [key stringByAppendingString: @".height"];
            
        result.width  = [self floatForKey: k1];
        result.height = [self floatForKey: k2];
        
        return result;
    }


/* NSPoint */

    - (void) setPoint: (NSPoint) point forKey: (NSString*) key; 
    {
        id k1 = [key stringByAppendingString: @".x"];
        id k2 = [key stringByAppendingString: @".y"];
        
        [self setFloat: point.x forKey: k1];
        [self setFloat: point.y forKey: k2];
    }
    
    - (NSPoint) pointForKey: (NSString*) key; 
    {	
        NSPoint result;
        id k1 = [key stringByAppendingString: @".x"];
        id k2 = [key stringByAppendingString: @".y"];
            
        result.x = [self floatForKey: k1];
        result.y = [self floatForKey: k2];
        
        return result;
    }


/* NSRect */

    - (void) setRect: (NSRect) rect forKey: (NSString*) key; 
    {
        id k1 = [key stringByAppendingString: @".origin"];
        id k2 = [key stringByAppendingString: @".size"];
        
        [self setPoint: rect.origin forKey: k1];
        [self setSize: rect.size forKey: k2];
    }
    
    - (NSRect) rectForKey: (NSString*) key; 
    {
        NSRect result;
        id k1 = [key stringByAppendingString: @".origin"];
        id k2 = [key stringByAppendingString: @".size"];
            
        result.origin = [self pointForKey: k1];
        result.size   = [self sizeForKey: k2];
        
        return result;
    }

@end