#import "DWColor.h"
#import "NSAttributedStringExtensions.h"
#import "NSStringExtensions.h"


/* Data */

@implementation NSString (Data)

    + (id) stringWithData: (NSData*) data; {
        return [[[NSString alloc] initWithData: data encoding: NSUTF8StringEncoding] autorelease];
    }
    
    - (id) data; {
        return [self dataUsingEncoding: NSUTF8StringEncoding allowLossyConversion: YES];
    }

@end


/* Extensions */

@implementation NSString (Extensions)

    - (NSString*) stringByStrippingWhitespace; {
        return [self stringByStrippingCharactersInSet: [NSCharacterSet whitespaceAndNewlineCharacterSet]];
    }
    
    - (NSString*) stringByStrippingCharactersInSet: (NSCharacterSet*) set; {
        NSMutableString* result = [[[NSMutableString alloc] init] autorelease];
        int i, count = [self length];
        for (i=0; i<count; i++) {
            unichar c = [self characterAtIndex: i];
            if (![set characterIsMember: c])
                [result appendFormat: @"%c", c];
        }
        return result;
    }
    
    - (BOOL) containsSubstring: (id) theString; {
        return ([self rangeOfString: theString options: 0].location != NSNotFound);
    }
    
    - (BOOL) containsSubstringCaseInsensitive: (id) theString; {
        return ([self rangeOfString: theString options: NSCaseInsensitiveSearch].location != NSNotFound);
    }

@end


/* Image */

@implementation NSString (Image)
    
    - (NSImage*) imageWithAttributes: (NSDictionary*) attributes; 
    {
        NSSize size = [self sizeWithAttributes: attributes];
        NSImage* result = [[[NSImage alloc] initWithSize: size] autorelease];
        if (size.width > 0) {
            [result lockFocus];
            [self drawAtPoint: (NSPoint){0,0} withAttributes: attributes];
            [result unlockFocus];
        }
        return result;
    }

    - (void) drawAtPoint: (NSPoint) thePoint withAttributes: (id) theAttributes backgroundColor: (id) theColor;
    {
        id copiedAttributes = nil;

        if (theColor == [DWColor alternateSelectedControlColor]) 
        {
            copiedAttributes = [[NSMutableDictionary alloc] initWithDictionary: theAttributes copyItems: NO];
            [copiedAttributes setObject: [NSColor whiteColor] forKey: NSForegroundColorAttributeName];
        }
                
        [self drawAtPoint: thePoint withAttributes: (copiedAttributes) ? copiedAttributes : theAttributes];
        
        [copiedAttributes release];
    }
    
    - (void) drawAtPoint: (NSPoint) thePoint withAttributes: (id) theAttributes backgroundColorIndex: (int) dwColorIndex whiteAlpha: (float) theAlpha;
    {
        NSAttributedString* theString = [[[NSAttributedString alloc] initWithString: self attributes: theAttributes] autorelease];
        if (dwColorIndex == kDWColorAlternateIndex) {
            if (theAlpha < 1) {
                theString = [theString attributedStringWithColor: [DWColor whiteColorBlendedWithAlternate]];
            } else {
                theString = [theString whiteAttributedString];
            }
        }
            
        [theString drawAtPoint: thePoint];
    }

@end

@implementation NSString (Hyperlinks)

    - (NSAttributedString *) hyperlink; {
        NSDictionary* attributes = [NSDictionary dictionaryWithObjectsAndKeys:
            [NSNumber numberWithInt:NSSingleUnderlineStyle], NSUnderlineStyleAttributeName,
            self, NSLinkAttributeName,
            [NSFont systemFontOfSize: 10.0], NSFontAttributeName,
            [NSColor colorWithCalibratedRed:0.1 green:0.1 blue:1.0 alpha:1.0], NSForegroundColorAttributeName,
        nil];
        return [[[NSAttributedString alloc] initWithString:self attributes:attributes] autorelease];
    }

    - (NSAttributedString *) hyperlinkPressed; {
        NSDictionary* attributes = [NSDictionary dictionaryWithObjectsAndKeys:
            [NSNumber numberWithInt:NSSingleUnderlineStyle], NSUnderlineStyleAttributeName,
            self, NSLinkAttributeName,
            [NSFont systemFontOfSize: 10.0], NSFontAttributeName,
            [NSColor colorWithCalibratedRed:1.0 green:0.1 blue:0.1 alpha:1.0], NSForegroundColorAttributeName,
        nil];
        return [[[NSAttributedString alloc] initWithString:self attributes:attributes] autorelease];
    }

@end