#import <Cocoa/Cocoa.h>


@interface NSString (Data)

+ (id) stringWithData: (NSData*) data;
- (id) data;

@end


@interface NSString (Extensions)

- (NSString*) stringByStrippingWhitespace;
- (NSString*) stringByStrippingCharactersInSet: (NSCharacterSet*) set;

- (BOOL) containsSubstring: (id) theString;
- (BOOL) containsSubstringCaseInsensitive: (id) theString;

@end


@interface NSString (Image)

- (void) drawAtPoint: (NSPoint) thePoint withAttributes: (id) theAttributes backgroundColor: (id) theColor;
- (void) drawAtPoint: (NSPoint) thePoint withAttributes: (id) theAttributes backgroundColorIndex: (int) dwColorIndex whiteAlpha: (float) theAlpha;
- (NSImage*) imageWithAttributes: (NSDictionary*) attributes;

@end


@interface NSString (Hyperlinks)

- (NSAttributedString *) hyperlink;
- (NSAttributedString *) hyperlinkPressed;

@end