#import "NSObjectExtensions.h"


@implementation NSObject (Events)

/* OS Version */

    - (BOOL) isOS102OrHigher; 
    {
        if (floor(NSAppKitVersionNumber) <= NSAppKitVersionNumber10_1) {
            /* On a 10.0 - 10.1.x system */
            return NO;
        } else {
            /* 10.2 or later system */
            return YES;
        }
    }

    - (BOOL) isOS103OrHigher; 
    {
        if (floor(NSAppKitVersionNumber) >= 703) {
            /* 10.3 dev preview + */
            return YES;
        } else {
            /* <= 10.2 */
            return NO;
        }
    }


/* Post Notification */

    - (void) postNotificationAboutSelf: (id) name; {
        [[NSNotificationCenter defaultCenter] postNotificationName: name object: self];
    }
    
    - (void) postNotificationAboutSelfLater: (id) name; {
        [self performSelector: @selector(postNotificationAboutSelf:) withObject: name afterDelay: 0];
    }
    

/* Listen For Notifications */
    
    - (void) listenForNotification: (id) name selector: (SEL) sel; {
        [[NSNotificationCenter defaultCenter] addObserver: self selector: sel name: name object: nil];
    }

    - (void) listenForNotification: (id) name selector: (SEL) sel object: (id) obj; {
        [[NSNotificationCenter defaultCenter] addObserver: self selector: sel name: name object: obj];
    }


/* Stop Listening For Notifications */

    - (void) stopListening; {
        [[NSNotificationCenter defaultCenter] removeObserver: self];
    }


/* Timers */

    - (id) repeatingTimerWithTimeInterval: (NSTimeInterval) interval selector: (SEL) sel; {
        return [NSTimer scheduledTimerWithTimeInterval: interval target: self selector: sel userInfo: nil repeats: YES];
    }
    

/* Optimized Hash Generation */
/* http://www.mulle-kybernetik.com/artikel/Optimization/opti-7.html */

    - (unsigned int) hash; {
        return(((unsigned int) self >> 4) | (unsigned int) self << (32 - 4));
    }

@end