#import "NSMutableDataExtensions.h"


@implementation NSMutableData (Bytes)

/* 1 byte */ 
- (void) appendChar: (char) value; {
    [self appendBytes: &value length: sizeof(char)];
}

/* 2 byte */ 
- (void) appendShort: (short) value; {
    [self appendBytes: &value length: sizeof(short)];
}

/* 4 byte */ 
- (void) appendInt: (int) value; {
    [self appendBytes: &value length: sizeof(int)];
}

/* 8 byte */ 
- (void) appendLongLong: (long long) value; {
    [self appendBytes: &value length: sizeof(long long)];
}


/* 1 byte */ 
- (void) appendByte:  (byte)  value; {
    [self appendBytes: &value length: sizeof(byte)];
}

/* 1 byte */ - (void) appendByte1: (byte1) value; {
    [self appendBytes: &value length: sizeof(byte)];
}

/* 2 byte */ 
- (void) appendByte2: (byte2) value; {
    [self appendBytes: &value length: sizeof(byte2)];
}

/* 4 byte */ 
- (void) appendByte4: (byte4) value; {
    [self appendBytes: &value length: sizeof(byte4)];
}

/* 8 byte */ 
- (void) appendByte8: (byte8) value; {
    [self appendBytes: &value length: sizeof(byte8)];
}

/* 16 byte */ 
- (void) appendByte16: (byte16) value; {
    [self appendBytes: &value length: sizeof(byte16)];
}


/* 1 byte */
- (void) serializeByte:   (byte)  value atIndex: (int) index; {
    NSRange r = {index, sizeof(byte)};
    [self replaceBytesInRange: r withBytes: &value];
}

/* 1 byte */
- (void) serializeByte1:  (byte1)  value atIndex: (int) index; {
    NSRange r = {index, sizeof(byte1)};
    [self replaceBytesInRange: r withBytes: &value];
}

/* 2 byte */  
- (void) serializeByte2:  (byte2)  value atIndex: (int) index; {
    NSRange r = {index, sizeof(byte2)};
    [self replaceBytesInRange: r withBytes: &value];
}

/* 4 byte */  
- (void) serializeByte4:  (byte4)  value atIndex: (int) index; {
    NSRange r = {index, sizeof(byte4)};
    [self replaceBytesInRange: r withBytes: &value];
}

/* 8 byte */  
- (void) serializeByte8:  (byte8)  value atIndex: (int) index; {
    NSRange r = {index, sizeof(byte8)};
    [self replaceBytesInRange: r withBytes: &value];
}

/* 16 byte */ 
- (void) serializeByte16: (byte16) value atIndex: (int) index; {
    NSRange r = {index, sizeof(byte16)};
    [self replaceBytesInRange: r withBytes: &value];
}

@end



@implementation NSMutableData (Data)

- (void) serializeData: (NSData*) value atIndex: (int)  index; {
    NSRange r = {index, [value length]};
    [self replaceBytesInRange: r withBytes: [value bytes]];
}

- (NSMutableData*) dataByAppendingData: (NSData*) theData; {
    [self appendData: theData];
    return self;
}

@end



@implementation NSMutableData (String)

- (void) appendString: (NSString*) value; {
    [self appendData: [value dataUsingEncoding: NSUTF8StringEncoding]];
}

- (void) serializeString: (NSString*) value atIndex: (int)  index; {
    [self serializeData: [value dataUsingEncoding: NSUTF8StringEncoding] atIndex: index];
}

@end