#import <Foundation/Foundation.h>
#import "NSDataExtensions.h"


@interface NSMutableData (Bytes)

/* 1 byte */ - (void) appendChar: (char) value;
/* 2 byte */ - (void) appendShort: (short) value;
/* 4 byte */ - (void) appendInt: (int) value;
/* 8 byte */ - (void) appendLongLong: (long long) value;

/* 1 byte */  - (void) appendByte:   (byte)   value;
/* 1 byte */  - (void) appendByte1:  (byte1)  value;
/* 2 byte */  - (void) appendByte2:  (byte2)  value;
/* 4 byte */  - (void) appendByte4:  (byte4)  value;
/* 8 byte */  - (void) appendByte8:  (byte8)  value;
/* 16 byte */ - (void) appendByte16: (byte16) value;

/* 1 byte */  - (void) serializeByte:   (byte)   value atIndex: (int) index;
/* 1 byte */  - (void) serializeByte1:  (byte1)  value atIndex: (int) index;
/* 2 byte */  - (void) serializeByte2:  (byte2)  value atIndex: (int) index;
/* 4 byte */  - (void) serializeByte4:  (byte4)  value atIndex: (int) index;
/* 8 byte */  - (void) serializeByte8:  (byte8)  value atIndex: (int) index;
/* 16 byte */ - (void) serializeByte16: (byte16) value atIndex: (int) index;

@end



@interface NSMutableData (Data)

- (void) serializeData: (NSData*) value atIndex: (int)  index;
- (NSMutableData*) dataByAppendingData: (NSData*) theData;

@end



@interface NSMutableData (String)

- (void) appendString: (NSString*) value;
- (void) serializeString: (NSString*) value atIndex: (int)  index;

@end