#import "NSMenuExtensions.h"


@implementation NSMenu (Extensions)

- (void) addSeparator; {
    [self addItem: [NSMenuItem separatorItem]];
}

- (id) addSubmenu: (id) theMenu withTitle: (id) theTitle; {
    NSMenuItem* result = [self addItemWithTitle: theTitle action: nil keyEquivalent: @""];
    [result setSubmenu: theMenu];
    return result;
}

- (id) addItemWithTitle: (id) theTitle action: (SEL) theAction target: (id) theTarget; {
    NSMenuItem* result = [self addItemWithTitle: theTitle action: theAction keyEquivalent: @""];
    [result setTarget: theTarget];
    return result;
}

- (id) addItemWithTitle: (id) theTitle action: (SEL) theAction target: (id) theTarget representedObject: (id) theObject; {
    NSMenuItem* result = [self addItemWithTitle: theTitle action: theAction keyEquivalent: @""];
    [result setTarget: theTarget];
    [result setRepresentedObject: theObject];
    return result;
}

- (BOOL) addItems: (NSArray*) theItems; {
    int i, count = [theItems count];
    BOOL atLeastOneEnabled = NO; 
    for (i=0; i<count; i++) {
        id item = [theItems objectAtIndex: i];
        [self addItem: item];
        if ([item target]) {
            atLeastOneEnabled = YES;
        }
    }
    return atLeastOneEnabled;
}

@end