#import "NSImageExtensions.h"


@implementation NSImage (Rect)


/* should setOpaque and setAlpha on rep */
- (id) initWithFocusedViewRect: (NSRect) rect; 
{
    self = [self initWithSize: rect.size];

    [self addRepresentation: [[[NSBitmapImageRep alloc] initWithFocusedViewRect: rect] autorelease]];
    [self setFlipped: YES];

    return self;
}

 
- (NSRect) rect; {
    return (NSRect){
        {0,0},
        [self size]
    };
}

- (BOOL) drawAtPoint: (NSPoint) thePoint; {
    [self drawAtPoint: thePoint fromRect: NSZeroRect operation: NSCompositeSourceAtop fraction: 1.0];
    return YES;
}
 
- (BOOL) drawAtPoint: (NSPoint) thePoint withOpacity: (float) theOpacity; {
    [self drawAtPoint: thePoint fromRect: NSZeroRect operation: NSCompositeSourceAtop fraction: theOpacity];
    return YES;
}

- (id) smallestRepresentation; {
    id reps = [self representations];
    id o, e = [reps objectEnumerator];
    int min = -1;
    id rep = nil;
    
    while ((o = [e nextObject])) {
        int width = [o pixelsWide];
        if (width < min || min < 0) {
            min = width;
            rep = o;
        }
    }
    
    return rep;
}

- (id) firstRepresentation; {
    return [[self representations] objectAtIndex: 0];
}

@end


@implementation NSImage (Silhouette)

    - (id) whiteSilhouette; {
        NSImage* white = [[NSImage alloc] initWithSize: [self size]];
        NSImage* silhouette = [self copy];
        
        /* generate a white rectangle */

            [white lockFocus];
            [[NSColor whiteColor] set];
            NSRectFill([white rect]);
            [white unlockFocus];
        
        /* paint white against the silhouette */
        
            [silhouette lockFocus];
            [white drawAtPoint: (NSPoint){0,0} fromRect: NSZeroRect operation: NSCompositeSourceIn fraction: 1.0];
            [silhouette unlockFocus];
            
        /* release and return */
        
            [white release];
            return [silhouette autorelease];
    }

@end