#import "NSFileManagerExtensions.h"


@implementation NSFileManager (Extensions)

- (void) createFileAtPathRecursive: (id) thePath; {
    [self createFileAtPathRecursive: thePath contents: nil attributes: nil];
}

- (void) createFileAtPathRecursive: (id) thePath contents: (id) contents attributes: (id) attributes; 
{
    id frags = [thePath pathComponents];
    unsigned i, count = [frags count];
    id currentPath = [NSString string];

    /* create directories & files if needed */

    #ifdef DEBUG
    NSLog(@"createFileAtPathRecursive");
    #endif

    for (i=0; i<count; i++)
    {
        currentPath = [currentPath stringByAppendingPathComponent: [frags objectAtIndex: i]];
        
        #ifdef DEBUG
        NSLog(currentPath);
        #endif
        
        if (![self fileExistsAtPath: currentPath]) {
            if (i != [frags count] - 1) {
                [self createDirectoryAtPath: currentPath attributes: nil];
            } else {
                [self createFileAtPath: currentPath contents: nil attributes: nil];
            }
        }
    }
}

- (void) createDirectoryAtPathRecursive: (id) thePath; 
{
    id frags = [thePath pathComponents];
    int i, count = [frags count];
    id currentPath = [NSString string];

    /* create directories if needed */

    #ifdef DEBUG
    NSLog(@"createFileAtPathRecursive");
    #endif

    for (i=0; i<count; i++)
    {
        currentPath = [currentPath stringByAppendingPathComponent: [frags objectAtIndex: i]];
        
        #ifdef DEBUG
        NSLog(currentPath);
        #endif
        
        if (![self fileExistsAtPath: currentPath]) {
            [self createDirectoryAtPath: currentPath attributes: nil];
        }
    }
}

@end