#import "NSDateExtensions.h"


@implementation NSDate (Extensions)

/* Time Conversion */

    static id HOURS = nil;
    static id MINUTES = nil;
    //static id SECONDS = nil;
    static id ONEHOUR = nil;
    static id ONEMINUTE = nil;

    + (NSString*) stringFromTimeInterval: (NSTimeInterval) theInterval;
    {
        if (!HOURS) {
            HOURS = [NSLocalizedStringFromTable(@"%i hours", @"NSDateExtensions", @"Time Format") retain];
            MINUTES = [NSLocalizedStringFromTable(@"%i minutes", @"NSDateExtensions", @"Time Format") retain];
            ONEHOUR = [NSLocalizedStringFromTable(@"1 hour", @"NSDateExtensions", @"Time Format") retain];
            ONEMINUTE = [NSLocalizedStringFromTable(@"1 minute", @"NSDateExtensions", @"Time Format") retain];
        }
        
        int seconds, minutes, hours, days, interval;
        interval = (int) theInterval;
        if (interval < 0) interval = -1 * interval;
        
        if (interval < 1) return @"";
        
        seconds = minutes = hours = days = 0;
        
        if (interval >= 0)     seconds =  interval         % 60;
        if (interval >= 60)    minutes = (interval / 60)   % 60;
        if (interval >= 3600)  hours   = (interval / 3600) % 24;
        if (interval >= 86400) days    =  interval / 86400;

        //if (days > 0) {
        //    return [NSString stringWithFormat: @"%i days", days, hours];
        //} else 
        if (hours > 0) {
            if (hours == 1) return ONEHOUR;
            else            return [NSString stringWithFormat: HOURS, hours, minutes];
        } else if (minutes > 0) {
            if (minutes == 1) return ONEMINUTE;
            else              return [NSString stringWithFormat: MINUTES, minutes, seconds];
        } else {
            //return [NSString stringWithFormat: @"%i s", seconds];
            return @"";
        }
    }


/* Comparison */

    - (BOOL) earlierThan: (NSDate*) date; {
        return ([date earlierDate: self] == self);
    }
    
    - (BOOL) laterThan: (NSDate*) date; {
        return ![self earlierThan: date];
    }

@end