#import <Foundation/Foundation.h>


/* Byte Extensions */

    typedef unsigned char      byte;
    typedef byte               byte1;
    typedef unsigned short     byte2;
    typedef unsigned int       byte4;
    typedef unsigned long long byte8;
    typedef struct {
        byte4 a;
        byte4 b;
        byte4 c;
        byte4 d;
    } 			       byte16;
        
    extern inline byte   deserializeByteAtIndex  (NSData*, unsigned);
    extern inline byte1  deserializeByte1AtIndex (NSData*, unsigned);
    extern inline byte2  deserializeByte2AtIndex (NSData*, unsigned);
    extern inline byte4  deserializeByte4AtIndex (NSData*, unsigned);
    extern inline byte8  deserializeByte8AtIndex (NSData*, unsigned);
    extern inline byte16 deserializeByte16AtIndex(NSData*, unsigned);
    
    @interface NSData (Byte)
    
    /* 1  byte */ - (byte)   deserializeByteAtIndex:   (unsigned) index;
    /* 1  byte */ - (byte1)  deserializeByte1AtIndex:  (unsigned) index;
    /* 2  byte */ - (byte2)  deserializeByte2AtIndex:  (unsigned) index;
    /* 4  byte */ - (byte4)  deserializeByte4AtIndex:  (unsigned) index;
    /* 8  byte */ - (byte8)  deserializeByte8AtIndex:  (unsigned) index;
    /* 16 byte */ - (byte16) deserializeByte16AtIndex: (unsigned) index;
    
    /* NSData  */ - (NSData*) deserializeDataAtIndex:  (unsigned) index;

    @end


    @interface NSData (Components)
    
    - (NSArray*) componentsSeparatedByByte:  (byte) value;
    - (NSArray*) componentsSeparatedByByte2: (byte) value;
    
    @end


/* String Extensions */

    @interface NSData (String)
    
    - (NSString*) string;
    
    - (NSData*) dataInRange: (NSRange) range;
    - (NSString*) stringInRange: (NSRange) range;
    
    - (NSData*) dataFromIndex: (int) index;
    - (NSString*) stringFromIndex: (int) index;

    - (NSString*) deserializeStringAtIndex: (int) index;
    
    @end
    

/* Subdata Extensions */

    @interface NSData (Subdata)
        
    - (NSArray*) componentsSeparatedByData: (NSData*) pattern;
    - (NSArray*) componentsSeparatedByString: (NSString*) pattern;
    
    - (int) indexOfData: (NSData*) pattern;
    - (int) indexOfData: (NSData*) pattern fromIndex: (int) index;

    - (int) indexOfString: (NSString*) pattern;
    - (int) indexOfString: (NSString*) pattern fromIndex: (int) index;
    
    - (NSData*) getDataUpToData: (NSData*) pattern;
    - (NSData*) getDataUpToString: (NSString*) pattern;
    
    - (NSData*) getDataUpToData: (NSData*) pattern fromIndex: (int) index;
    - (NSData*) getDataUpToString: (NSString*) pattern fromIndex: (int) index;
    
    @end