#import "DWColor.h"
#import "NSAttributedStringExtensions.h"


@implementation NSAttributedString (Extensions)

- (NSAttributedString*) attributedStringWithColor: (id) theColor; {
    id result = [[[NSMutableAttributedString alloc] initWithAttributedString: self] autorelease];
    id attributes = [[[NSDictionary alloc] initWithObjectsAndKeys: theColor, NSForegroundColorAttributeName, nil] autorelease];
    [result addAttributes: attributes range: (NSRange){0, [self length]}];
    return result;
}

- (NSAttributedString*) whiteAttributedString; {
    return [self attributedStringWithColor: [DWColor whiteColor]];
}

- (NSAttributedString*) whiteAttributedStringWithAlpha: (float) alpha; {
    return [self attributedStringWithColor: [[DWColor whiteColor] colorWithAlphaComponent: alpha]];
}

@end