/*
** AqApplicationController
** 
** CHANGES:
** 0.23 (pozytron) Added Progress bar to dock icon
*/

#import "AqApplicationController.h"
#import "AqApp(Dialogs).h"
#import "AqContentViewController.h"
#import "AqDownloadsController.h"
#import "AqDrawerController.h"
#import "AqFilterController.h"
#import "AqIPFilter.h"
#import "AqiTunesController.h"
#import "AqCoreController.h"
#import "AqNetworkController.h"
#import "AqPreferencesController.h"
#import "AqUploadsController.h"
#import "AqQueryController.h"
#import "AqRendezvousController.h"
#import "AqURLHandler.h"
#import "DWVersionChecker.h"
#import "NSDataExtensions.h"


@implementation AqApplicationController

/* Initialization */

    static id instance = nil;
    + (id) instance; {
        return instance;
    }

    - (void) applicationWillFinishLaunching: (id) notification;
    {
        instance = self;
    
        /* checks */
                        
            [self checkEnvironment];
            [self performSelector: @selector(c) withObject: nil afterDelay: 2];
            [self performSelector: @selector(checkSharing) withObject: nil afterDelay: 3];
            [self performSelector: @selector(check) withObject: nil afterDelay: 15];
            
        /* initialize Aq elements here */
        
            [AqQueryController instance];
            [AqNetworkController instance];
            [AqDownloadsController instance];
            [AqUploadsController instance];
            [AqRendezvousController instance];
            
            [AqApplicationController updateDockIcon];

        /* URL handling */
            
            [[NSAppleEventManager sharedAppleEventManager] setEventHandler: [AqURLHandler class] andSelector: @selector(handleURLEvent:) forEventClass: kInternetEventClass andEventID: kAEGetURL];
    }

    - (void) applicationDidFinishLaunching: (id) notification;
    {
            
        /* open window */
           
            [AqCoreController instance];
            
        /* NSNotication catch-all */
            
            #if 0
                [[NSNotificationCenter defaultCenter] addObserver: self selector: @selector(notification:) name: nil object: nil];
            #endif
            
            #if 0
                [[NSNotificationCenter defaultCenter] addObserver: self selector: @selector(notification:) name: NSViewFrameDidChangeNotification object: nil];
            #endif 
         
    }
    
    - (void) notification: (id) notification; {
        NSLog(@"%@", notification);
    }
    

/* Reopen */

    - (BOOL) applicationShouldHandleReopen: (id) app hasVisibleWindows: (BOOL) value; {
        [[AqDrawerController instance]->window makeKeyAndOrderFront: self];
        return NO;
    }
    

#pragma mark -
/* Termination */
    
    - (NSApplicationTerminateReply) applicationShouldTerminate: (id) sender; {
        [[AqDrawerController instance]->window orderOut: self];
        [[AqCoreController instance] terminateCore];
        return NSTerminateNow;
    }
    
    - (void) applicationWillTerminate: (id) notification; 
    {
        if ([AqDrawerController instance]) 
            [[AqDrawerController instance]->window saveFrameUsingName: @"kAqMainWindow"];

        [[AqQueryController instance] applicationWillTerminate];
        [[AqDrawerController instance] applicationWillTerminate];
        [[AqFilterController instance] applicationWillTerminate];
        [[AqIPFilter instance] applicationWillTerminate];
        [[AqRendezvousController instance] applicationWillTerminate];
        [[AqContentViewController instance] applicationWillTerminate];

        [NSApp setApplicationIconImage: [NSImage imageNamed: 
            [defaults integerForKey: @"AcqIconScheme"] ? @"AcqliteGreen" : @"AcqliteRed"]];
    }
    

/* Dock */

#define AqDC [AqDownloadsController instance]
    + (void) updateDockIcon; {
        static id   savedColor = nil;
        static int  savedWidth = -1;
        static BOOL savedBadged = NO;
        id otherColor = nil;
        BOOL drawProgress = ([defaults boolForKey: @"AcqProgressInDock"] && (AqDC->active > 0));
        
        if ([savedColor isEqual: [defaults integerForKey: @"AcqIconScheme"] ? @"Green" : @"Red"] && 
            savedBadged == (AqDC->complete > 0) && 
            savedWidth == (int)[AqDrawerController statusDownloadPercent]) return;
            
        //NSLog(@"updateDockIcon(color:%@ percent:%i badged:%i)", savedColor, savedWidth, (int)savedBadged);
            
        [savedColor release];
        savedColor = [defaults integerForKey: @"AcqIconScheme"] ? @"Green" : @"Red";
        savedBadged = (AqDC->complete > 0);
        savedWidth = (int)[AqDrawerController statusDownloadPercent];
        otherColor = ![defaults integerForKey: @"AcqIconScheme"] ? @"Green" : @"Red";
        
        id icon = [NSImage imageNamed: [NSString stringWithFormat: @"Acqlite%@", savedColor]];
        id badge = [NSImage imageNamed: [NSString stringWithFormat: @"AcqBadge%@", otherColor]];
        id final = [[NSImage alloc] initWithSize: NSMakeSize(128,128)];
        [final lockFocus];
            [icon drawAtPoint: NSZeroPoint fromRect: NSZeroRect operation: NSCompositeSourceOver fraction: 1.0];
            if (savedBadged)
                [badge drawAtPoint: NSMakePoint(80,67) fromRect: NSZeroRect operation: NSCompositeSourceOver fraction: 1.0];
            if (drawProgress) {
                NSRect barRect, frameRect = NSMakeRect(13, 4, 102, 12);
                NSDrawGrayBezel(frameRect, frameRect);
                [[NSColor colorWithDeviceRed: 0.07 green:0.5 blue:0.85 alpha:1.0] set];
                barRect = NSInsetRect(frameRect, 1, 2);
                barRect.size.width = savedWidth;
                NSRectFill(barRect);
            }
        [final unlockFocus];
                
        [NSApp setApplicationIconImage: final];
    }

@end