/*
** AqAppMessageBridge
** 
** CHANGES:
** 0.1  (pozytron) Changed Link Destinations
** 0.2  (pozytron) Removed downloadTips, added submitBugReport
** 0.23 (pozytron) Changed some link destinations
*/

#import "DWVersionChecker.h"
#import "AqAppMessageBridge.h"
#import "AqURLHandler.h"


@implementation AqAppMessageBridge

/* Events */

    - (void) awakeFromNib; {
        if (!preferencesPanel) [NSBundle loadNibNamed: @"Preferences" owner: self];
    }
    
    
/* Application Menu */

    - (IBAction) showAboutPanel: (id) sender; {
        if (!aboutBox) [NSBundle loadNibNamed: @"AboutBox" owner: self];
        [aboutBox center];
        [aboutBox makeKeyAndOrderFront: self];
    }

    - (IBAction) checkForUpdates: (id) sender; {
        [[DWVersionChecker sharedChecker] checkVersionUserInitiated: YES];
    }

    - (IBAction) showPreferences: (id) sender; {
        [preferencesPanel makeKeyAndOrderFront: self];
    }


/* Edit Menu */

    - (IBAction) copyBrowseURL: (id) sender; {
        [[NSPasteboard generalPasteboard] declareTypes: [NSArray arrayWithObject: NSStringPboardType] owner: self];
        [[NSPasteboard generalPasteboard] setString: [AqURLHandler localBrowseURL] forType: NSStringPboardType];
    }


/* View Menu */
    
    - (IBAction) hideToolbar: (id) sender; {
        [[NSApp mainWindow] toggleToolbarShown: self];
    }
    
    - (IBAction) customizeToolbar: (id) sender; {
        [[NSApp mainWindow] runToolbarCustomizationPalette: self];
    }


/* Help Menu */
    
    - (IBAction) website: (id) sender; {
        [[NSWorkspace sharedWorkspace] openURL: [NSURL URLWithString: @"http://www.acqlite.org/"]];
    }

    - (IBAction) support: (id) sender; {
        [[NSWorkspace sharedWorkspace] openURL: [NSURL URLWithString: @"http://www.acqlite.org/?forums"]];
    }
    
    - (IBAction) email: (id) sender; {
        [[NSWorkspace sharedWorkspace] openURL: [NSURL URLWithString: [NSString stringWithFormat: @"mailto:acqlite@pozytron.com?subject=%@%%20%@", [DWVersionChecker applicationName], [DWVersionChecker applicationVersion]]]];
    }

    - (IBAction) help: (id) sender; {
        [[NSWorkspace sharedWorkspace] openURL: [NSURL URLWithString: @"http://www.acqlite.org/?help"]];
    }

    - (IBAction) submitBugReport: (id) sender; {
        [[NSWorkspace sharedWorkspace] openURL: [NSURL URLWithString: @"https://sourceforge.net/tracker/?func=add&group_id=89065&atid=588889"]];
    }

@end