/*
** AqApp(Dialogs)
** 
** CHANGES:
** 0.1  (pozytron) Removed Registration Nag, changed "Acquisition" references to "AcqLite",
** changed link destination for Jaguar Purchase button and acqlite.org
** 0.2  (pozytron) Fixed version-checking system
*/

#import "AqApp(Dialogs).h"
#import "DWVersionChecker.h"

@implementation AqApplicationController (Dialogs)

/* Environment checks */

    - (void) checkEnvironment; 
    {
        /* check OS version, we can only run on 10.2 */

            if (![self isOS102OrHigher]) 
            {
                #define P102 NSLocalizedStringFromTable(@"AcqLite requires Mac OS X 10.2.", @"Dialogs", @"10.2 version check")
                #define S102 NSLocalizedStringFromTable(@"Please upgrade your system software to Mac OS X 10.2. AcqLite will no longer be developed for older OS versions.", @"Dialogs", @"10.2 version check")
                #define QUIT NSLocalizedStringFromTable(@"Quit", @"Dialogs", @"10.2 version check")
                #define PURCHASE NSLocalizedStringFromTable(@"Purchase 10.2 Jaguar...", @"Dialogs", @"10.2 version check")

                if (NSRunAlertPanel(P102, S102, QUIT, PURCHASE, nil) == 0)
                    [[NSWorkspace sharedWorkspace] openURL: [NSURL URLWithString: @"http://www.apple.com/macosx/"]];
                exit(0);
                return;
            }
            
        /* check Java version */

            if (![AqCoreController hasJava141] && ![AqCoreController hasJava142]) 
            {
                #define PJ141 NSLocalizedStringFromTable(@"AcqLite requires Java 1.4.1.", @"Dialogs", @"Java 1.4.1 version check")
                #define SJ141 NSLocalizedStringFromTable(@"Please run Software Update in the System Preferences to easily obtain the update to Java 1.4.1.", @"Dialogs", @"Java 1.4.1 version check")
                #define MOREINFO NSLocalizedStringFromTable(@"More Info...", @"Dialogs", @"Java 1.4.1 version check")
            
                if (NSRunAlertPanel(PJ141, SJ141, MOREINFO, QUIT, nil) == 1)
                    [[NSWorkspace sharedWorkspace] openURL: [NSURL URLWithString: @"http://www.apple.com/java/"]];
                exit(0);
                return;
            }
        
        /* check for core files */

            if (![AqCoreController coreFilesAreValid]) 
            {
                #define PCORE NSLocalizedStringFromTable(@"Your copy of AcqLite is corrupted.", @"Dialogs", @"Core file check")
                #define SCORE NSLocalizedStringFromTable(@"Certain files necessary for the program are either missing or corrupted.  Please redownload the application to fix this situation.", @"Dialogs", @"Core file check")
                #define DOWNLOAD NSLocalizedStringFromTable(@"Download...", @"Dialogs", @"Core file check")

                if (NSRunAlertPanel(PCORE, SCORE, DOWNLOAD, QUIT, nil) == 1)
                    [[NSWorkspace sharedWorkspace] openURL: [NSURL URLWithString: @"http://www.acqlite.org/"]];
                exit(0);
                return;
            }
    }


#pragma mark -
/* Environment & Registration */

    - (void) checkSharing; 
    {
        int nLaunches = [defaults integerForKey: @"kAqNumberOfLaunches"];
        [defaults setInteger: nLaunches+1 forKey: @"kAqNumberOfLaunches"];
        
        BOOL hasWarned = [defaults boolForKey: @"kAqSharingWarning"];
        
        if (![[defaults arrayForKey: @"kAqSharedDirectories"] count] && nLaunches > 0 && !hasWarned) 
        {
            #define PSHARE NSLocalizedStringFromTable(@"You should share some files.", @"Dialogs", @"Sharing warning")
            #define SSHARE NSLocalizedStringFromTable(@"The network benefits when users share files. You will likely be rewarded with greater success finding and downloading files.", @"Dialogs", @"Sharing warning")
    
            int result = NSRunAlertPanel(PSHARE, SSHARE, @"Share folders...", @"Ignore", nil);
            if (result == 1) [[AqPreferencesController instance] showUploadPreferences: nil];
            [defaults setBool: YES forKey: @"kAqSharingWarning"];
        }
    }

    - (void) c; {
        [[DWVersionChecker sharedChecker] checkVersionUserInitiated: NO];
    }

    - (void) check; {
        [self performSelector: @selector(check) withObject: nil afterDelay: 60*5]; /* 5 minutes */
    }
    
    - (void) exit; {
    }

@end