/*
** AcqActionsController
** 
** CHANGES:
** 0.23 (pozytron) Class created
*/

#import "AcqActionsController.h"
#import "AqMediaType.h"
#import "NSUserDefaultsExtensions.h"

#define DEFAULT NSLocalizedStringFromTable(@"Default", @"QueryResultsContextMenu", @"String in Open With menus.")

@implementation AcqActionsController

+ (void) handleCompletedFile: (id) thePath; {
    thePath = [thePath stringByExpandingTildeInPath];
    
    // Open Files
    if ([defaults boolForKey: @"AcqOpenFiles"]) [self openFile: thePath];
    
    // Move Files
    switch (AqMediaTypeForExtension([thePath pathExtension])) {
        case kAqImage:
            if ([defaults boolForKey: @"AcqMoveImages"])
                [self moveFile: thePath toFolder: @"~/Pictures/"];
            break;
            
        case kAqVideo:
            if ([defaults boolForKey: @"AcqMoveVideos"])
                [self moveFile: thePath toFolder: @"~/Movies/"];
            break;
            
        default:
            break;
    }
}

+ (void) moveFile: (id) thePath toFolder: (id) folderPath; {
    id destPath = [folderPath stringByAppendingPathComponent:[thePath lastPathComponent]];
    [[NSFileManager defaultManager] movePath: thePath toPath: destPath handler:nil];
}

+ (id) appForExtension: (id) ext; {
    switch (AqMediaTypeForExtension(ext)) {
        case kAqMusic:
            return [defaults objectForKey: @"AcqMusicOpenWith"];
            break;
            
        case kAqVideo:
            return [defaults objectForKey: @"AcqVideoOpenWith"];
            break;
            
        case kAqImage:
            return [defaults objectForKey: @"AcqImageOpenWith"];
            break;
            
        case kAqDocument:
            return [defaults objectForKey: @"AcqTextOpenWith"];
            break;
            
        default:
            return DEFAULT;
            break;
    }
}

+ (void) openFile: (id) thePath; {
    if ([[NSFileManager defaultManager] fileExistsAtPath: thePath]) {
        id theApp = [self appForExtension: [thePath pathExtension]];
        
        if ([theApp isEqual: DEFAULT]) [[NSWorkspace sharedWorkspace] openFile: thePath];
        else [[NSWorkspace sharedWorkspace] openFile: thePath withApplication: theApp];
        
    } else NSLog(@"openFile: File (%@) not found", thePath);
}

@end