// PiTunesController.m
// -------------------------------------------------------------------------
// Copyright (C) 2003 Poisoned Project (http://www.gottsilla.net/)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// ---------------------------------------------------------------------------


#import "PiTunesController.h"
#import "FileHandle.h"

#define userDefaults [NSUserDefaults standardUserDefaults]

@implementation PiTunesController

+ (void)handleCompletedFile:(id)theFileWithPath;
{
	theFileWithPath = [theFileWithPath stringByExpandingTildeInPath];
    if (([[NSFileManager defaultManager] fileExistsAtPath: theFileWithPath]) && ([userDefaults boolForKey: @"PAddSong"]))
	{
		BOOL check = NO;
            
		if ([userDefaults boolForKey: @"PAddSongToPlaylist"])
			check = [PiTunesController addSongToPlaylist: theFileWithPath];
		else 
			check = [PiTunesController addSongToLibrary: theFileWithPath];
            
		if (check) 
		{
			switch ([userDefaults integerForKey: @"PPlaySong"])
			{
				case 0:
					break;
				case 1:
					[PiTunesController playSong: theFileWithPath: @"if stash is 0 then"];
					break;
				case 2:
					[PiTunesController playSong: theFileWithPath: @"if player state is not playing then"];
					break;
			}
		}

		if (check && [userDefaults boolForKey: @"PDeleteAfterImport"])
			[FileHandle moveFileToUserTrash : theFileWithPath];
	}
}

+ (BOOL)doAppleScript:(id)appleScriptString;
{
	NSLog(@"appleScriptString: %@", appleScriptString);
	NSDictionary *status = NULL;
	NSAppleScript *scriptObject = [[NSAppleScript alloc] initWithSource: appleScriptString];
	NSAppleEventDescriptor *descriptor = [scriptObject executeAndReturnError: &status];
	[scriptObject release];
	if ([descriptor descriptorType] == 'obj ')
		NSLog(@"appleScriptString run successfully");
	else if ([descriptor descriptorType] == typeNull)
	{
		NSLog(@"appleScriptString is still running");
		return NO;
	}
	else
	{
		NSLog(@"appleScriptString returned error: %@", [status objectForKey: @"NSAppleScriptErrorMessage"]);
		return NO;
	}
	return YES;
}

+ (BOOL)addSongToLibrary:(id)theFileWithPath;	
{
	NSString *scriptSource;
	
	scriptSource = [NSString stringWithFormat:[NSString stringWithCString:
	"tell application \"iTunes.app\"\n"
	"launch\n"
	"    add POSIX file \"%@\" to library playlist 1\n"
	"end tell"], theFileWithPath];

	return [self doAppleScript: scriptSource];
}
    
+ (BOOL)addSongToPlaylist:(id)theFileWithPath;     
{
	NSString *scriptSource;
                
	scriptSource = [NSString stringWithFormat:[NSString stringWithCString:
	"tell application \"iTunes.app\"\n"
	"   launch\n"
	"   set playlist_name to \"%@\"\n"
	"   if not (exists playlist named playlist_name) then\n"
	"		set poisoned_playlist to (make new playlist with properties {name:playlist_name})\n"
	"	else\n"
	"		set poisoned_playlist to (playlist named playlist_name)\n"
	"   end if\n"
	"   add POSIX file \"%@\" to poisoned_playlist\n"
	"end tell"], [userDefaults objectForKey:@"PImportPlaylistName"], theFileWithPath];

	return [self doAppleScript: scriptSource];
}
    
+ (void)playSong:(id)theFileWithPath:(id)playStateString;
{
	NSString *scriptSource, *playString;

	if ([userDefaults boolForKey: @"PAddSongToPlaylist"])
		playString = [NSString stringWithFormat:@"playlist \"%@\"", [userDefaults objectForKey:@"PImportPlaylistName"]];
	else 
		playString=@"library playlist 1";
		
	scriptSource = [NSString stringWithFormat:[NSString stringWithCString:
	"set cd to (get current date)\n"
	"set stash to 0\n"
	"tell application \"iTunes.app\"\n"
	"launch\n"
	"%@\n"
	"set theLib to %@\n"
	"repeat with t from 1 to (count every track of theLib)\n"
	"	tell track t of theLib\n"
	"		set tDif to (cd - (get date added))\n"
	"		if stash is 0 or stash is greater than tDif then\n"
	"			copy tDif to stash\n"
	"			set theLoc to t\n"
	"		end if\n"
	"	end tell\n"
	"end repeat\n"
	"play track theLoc of theLib\n"
	"end if\n"
	"end tell"], playStateString, playString];
	
	[self doAppleScript: scriptSource];
}

@end