#!/usr/bin/env python
import sys
from PyQt4 import QtCore, QtGui, uic

form_class, base_class = uic.loadUiType("timeLineWidget.ui")
class TwitturnTimeLineWidget(base_class, form_class):
    def __init__(self, *args):
        base_class.__init__(self, *args)
        self.parentTabWidget = args[0]

        self.setupUi(self)
        self.settings = QtCore.QSettings("Twitturn")
        self.connectActions()

        self.loadSettings()

    def setNotify(self, notify):
        tabWidget = self.parentTabWidget
        idx = tabWidget.indexOf(self)
        if notify:
            tabWidget.setTabIcon(idx, QtGui.QIcon("images/new.png"))
        else:
            tabWidget.setTabIcon(idx, QtGui.QIcon())
    def changeThisTab(self):
        tabWidget = self.parentTabWidget
        if not tabWidget.currentWidget() == self:
            tabWidget.setCurrentWidget(self)
        else:
            if self.treeWidget.indexOfTopLevelItem(
                    self.treeWidget.currentItem()) == -1:
                self.treeWidget.setCurrentItem(
                    self.treeWidget.topLevelItem(0))
            self.treeWidget.setFocus()

    def connectActions(self):
        pass

    def closeEvent(self, event):
        self.saveSettings()

    def loadSettings(self):
        self.treeWidget.header().restoreState(
                self.settings.value("GUI/treeWidget/header").toByteArray())

    def saveSettings(self):
        pass

    def addPost(self, post, clone=True):
        insertItem = post
        if clone:
            insertItem = post.clone()

        for i in range(self.treeWidget.topLevelItemCount()):
            item = self.treeWidget.topLevelItem(i)
            if post.text(3) >=  item.text(3) :
                self.treeWidget.insertTopLevelItem(i, insertItem)
                return
        self.treeWidget.insertTopLevelItem(
                self.treeWidget.topLevelItemCount(),
                insertItem)

    def highlightNics(self, nicks):
        highlitCheckRange = 100

        self.treeWidget.clearSelection()
        
        currentItem = self.treeWidget.currentItem()
        idx = self.treeWidget.indexOfTopLevelItem(currentItem)

        for i in range(
                max(idx-highlitCheckRange, 0),
                min(
                    idx+highlitCheckRange, 
                    self.treeWidget.topLevelItemCount())):
            item = self.treeWidget.topLevelItem(i)
            for nick in nicks:
                if item.text(1) == nick:
                    self.treeWidget.setItemSelected(item, True)


if __name__=="__main__":
    app = QtGui.QApplication(sys.argv)
    form = TwitturnTimeLineWidget()
    form.show()
    app.exec_()
