# -*- coding: utf-8 -*-
import urllib,ConfigParser
from xml.sax.handler import ContentHandler
import httputil,xmlutil
query_host = 'http://yp.shoutcast.com/'
query_url_base = query_host + 'sbin/newxml.phtml?'
limit_query = '&limit=%s'

class StationListHandler(ContentHandler):
    def __init__(self,callback):
        self.__callback = callback

    def startElement(self, name, attrs):
        if name == 'station':
            info = (attrs.getValue('mt'),
                    attrs.getValue('br'),
                    attrs.getValue('genre'),
                    attrs.getValue('lc'),
                    attrs.getValue('ct'))

            url = query_host + 'sbin/tunein-station.pls?id=%s' % attrs.getValue('id')
            self.__callback(attrs.getValue('name'),
                            url,
                            info=info)

class GenreListHandler(ContentHandler):
    def __init__(self,callback):
        self.__callback = callback

    def startElement(self, name, attrs):
        if name == 'genre':
            self.__callback(attrs.getValue('name'))

class PlayListParser:
    def __init__(self,fileobj):
        self.parser = ConfigParser.RawConfigParser()
        self.parser.readfp(fileobj)

    def get_active_item(self):
        com = httputil.UrlCominucator(self.iteritems())
        return com.get_active_link()

    def get_item(self,sec,index):
        return self.parser.get(sec,'File%d' % index)

    def iteritems(self):
        sec ='playlist'
        entry_sum = self.parser.getint(sec,'numberofentries')
        if entry_sum == 1:
            yield self.get_item(sec,entry_sum)
        else:
            for i in range(1,entry_sum):
                yield self.get_item(sec,i)

def translate_info(*args):
    args = args[0]
    mime,bitrate,genre = args[0:3]
    format = mime.split('/')[1].upper()
    info = '[%s %skb] Genre: %s' % (format,
                                    bitrate,
                                    genre)
    if len(args) > 3:
        info += '\n[Listen: %s] Playing: %s' % args[3:]
    return info

def saxing_url_resource(url,handler):
    opener = httputil.get_opener()
    source = opener.open(url)
    xmlutil.saxing_data(source,handler)

def get_playlist(url):
    opener = httputil.get_opener()
    return opener.open(url)#(query_host + 'sbin/tunein-station.pls?id=%s' % id)

def get_stations(genre,limit):
    target = (query_url_base +'genre=%s'  + limit_query )% (genre,limit)
    return httputil.get_opener().open(target)

def search_stations(search_text,bitrate,codec,
                    limit):
    target = (query_url_base + \
                  'search=%s&bitrate=%s&mt=%s' + limit_query) \
                  % (urllib.quote(search_text),bitrate,codec,limit)
    return httputil.get_opener().open(target)

def parse_station_list(resource,callback):
    handler = StationListHandler(callback)
    xmlutil.saxing_data(resource,handler)

def is_support_playlist():
    return True

def get_codec_mimes():
    return ['audio/mpeg',
             'audio/aacp',
             'audio/aac',
             'audio/ogg',
             'audio/flac']


if __name__ == '__main__':
    genre_list_url = 'http://www.shoutcast.com/sbin/newxml.phtml'
    from cStringIO import StringIO
    result = StringIO()
    callback = lambda name:result.write('"%s",' % name)
    handler = GenreListHandler(callback)
    saxing_url_resource(genre_list_url,handler)
    print '[' + result.getvalue().strip(',') + ']'
    result.close()
