/*
 *                 Sun Public License Notice
 * 
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 * 
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package vcs.commands.passwd;

import java.util.ArrayList;
import javax.swing.SwingUtilities;

import org.openide.util.RequestProcessor;

import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.netbeans.modules.vcscore.VcsFileSystem;

/**
 *
 * @author  Martin Entlicher
 * @version 
 */
public class CvsLoginDialog extends javax.swing.JDialog {

    public final Object STATUS_CONNECTING = new Integer(0);
    public final Object STATUS_FAILED = new Integer(1);
    
    private static ArrayList lastSuccessfullLoggings = new ArrayList();

    private String connectStr = "";
    private PasswdEntry entry = null;
    private boolean loggedIn = false;
    private boolean offline = false;
    private String password = null;
    private Thread loginThread = null;
    private VcsFileSystem fileSystem = null;

    /** Creates new form LoginDialog */
    public CvsLoginDialog(java.awt.Frame parent, boolean modal) {
        super (parent, modal);
        initComponents ();
        passwordLabel.setDisplayedMnemonic(org.openide.util.NbBundle.getBundle(CvsLoginDialog.class).getString("LoginDialog.passwordLabel.text_Mnemonic").charAt(0));  // NOI18N
        loginButton.setMnemonic(org.openide.util.NbBundle.getBundle(CvsLoginDialog.class).getString("LoginDialog.loginButton.text_Mnemonic").charAt(0));  // NOI18N
        offlineButton.setMnemonic(org.openide.util.NbBundle.getBundle(CvsLoginDialog.class).getString("LoginDialog.offlineButton.text_Mnemonic").charAt(0));  // NOI18N
        setTitle(org.openide.util.NbBundle.getBundle(CvsLoginDialog.class).getString("LoginDialog.title"));
        pack ();
        VcsUtilities.removeEnterFromKeymap(passwordField);
        getRootPane().setDefaultButton(loginButton);
        initAccessibility();
    }
    
    private void initAccessibility()
    {
        getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getBundle(CvsLoginDialog.class).getString("ACS_LoginDialogA11yName"));  // NOI18N
        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getBundle(CvsLoginDialog.class).getString("ACS_LoginDialogA11yDesc"));  // NOI18N
        loginLabel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getBundle(CvsLoginDialog.class).getString("ACS_LoginDialog.loginLabel.textA11yDesc"));  // NOI18N
        passwordLabel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getBundle(CvsLoginDialog.class).getString("ACS_LoginDialog.passwordLabel.textA11yDesc"));  // NOI18N
        passwordField.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getBundle(CvsLoginDialog.class).getString("ACS_passwordFieldA11yName"));  // NOI18N
        statusLabel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getBundle(CvsLoginDialog.class).getString("ACS_LoginDialog.statusA11yDesc"));  // NOI18N
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        loginPanel = new javax.swing.JPanel();
        loginLabel = new javax.swing.JLabel();
        passwordLabel = new javax.swing.JLabel();
        passwordField = new javax.swing.JPasswordField();
        buttonPanel = new javax.swing.JPanel();
        loginButton = new javax.swing.JButton();
        offlineButton = new javax.swing.JButton();
        statusPanel = new javax.swing.JPanel();
        statusLabel = new javax.swing.JLabel();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        loginPanel.setLayout(new java.awt.GridBagLayout());

        loginLabel.setText(org.openide.util.NbBundle.getBundle(CvsLoginDialog.class).getString("LoginDialog.loginLabel.text"));
        loginLabel.setLabelFor(loginLabel);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 8, 0);
        loginPanel.add(loginLabel, gridBagConstraints);

        passwordLabel.setText(org.openide.util.NbBundle.getBundle(CvsLoginDialog.class).getString("LoginDialog.passwordLabel.text"));
        passwordLabel.setLabelFor(passwordField);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 8);
        loginPanel.add(passwordLabel, gridBagConstraints);

        passwordField.setToolTipText(org.openide.util.NbBundle.getBundle(CvsLoginDialog.class).getString("ACS_passwordFieldA11yDesc"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        loginPanel.add(passwordField, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 8, 8);
        getContentPane().add(loginPanel, gridBagConstraints);

        buttonPanel.setLayout(new java.awt.GridBagLayout());

        loginButton.setToolTipText(org.openide.util.NbBundle.getBundle(CvsLoginDialog.class).getString("ACS_LoginDialog.loginButton.textA11yDesc"));
        loginButton.setText(org.openide.util.NbBundle.getMessage(CvsLoginDialog.class, "LoginDialog.loginButton.text"));
        loginButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loginButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        buttonPanel.add(loginButton, gridBagConstraints);

        offlineButton.setToolTipText(org.openide.util.NbBundle.getBundle(CvsLoginDialog.class).getString("ACS_LoginDialog.offlineButton.textA11yDesc"));
        offlineButton.setText(org.openide.util.NbBundle.getMessage(CvsLoginDialog.class, "LoginDialog.offlineButton.text"));
        offlineButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                offlineButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        buttonPanel.add(offlineButton, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 8, 8, 8);
        getContentPane().add(buttonPanel, gridBagConstraints);

        statusPanel.setLayout(new java.awt.GridBagLayout());

        statusPanel.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED));
        statusLabel.setText(" ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 8, 0, 8);
        statusPanel.add(statusLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 8, 8, 8);
        getContentPane().add(statusPanel, gridBagConstraints);

    }//GEN-END:initComponents

  private void offlineButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_offlineButtonActionPerformed
// Add your handling code here:
      loggedIn = false;
      if (loginThread != null) {
          if (loginThread.isAlive()) {
              loginThread.interrupt();
          }
      }
      offline = true;
      closeDialog(null);
  }//GEN-LAST:event_offlineButtonActionPerformed

  private void loginButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loginButtonActionPerformed
// Add your handling code here:
      //loginThread = new Thread("CVS_AUTHORIZING_THREAD") {
      RequestProcessor.postRequest(new Runnable() {
          public void run() {
              CVSPasswd pasFile = new CVSPasswd((String)null);
              pasFile.loadPassFile();
              password = new String(passwordField.getPassword());
              //entry = new PasswdEntry();
              pasFile.remove(connectStr);
              pasFile.add(connectStr, password); //CVSPasswd.scramble(password));
              pasFile.savePassFile();
              //boolean setRight = entry.setEntry(connectStr + " " + CVSPasswd.scramble(password));
              //if (!setRight) {D("wrongly set entry.");}
              checkLogin();
          }
      });
      //loginThread.start();
  }//GEN-LAST:event_loginButtonActionPerformed

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible (false);
        dispose ();
    }//GEN-LAST:event_closeDialog

    private boolean wasLoggedIn() {
        return lastSuccessfullLoggings.contains(connectStr);
    }
    
    /**
     * Show the login dialog and start the login process immediately.
     */
    public void showLogging() {
        if (wasLoggedIn()) {
            loggedIn = true; // believe, that the user is still correctly logged in
            return;
        }
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                SwingUtilities.invokeLater(new Runnable() {
                    public void run() {
                        Runnable login = new Runnable() {
                            public void run() {
                                checkLogin(); // this should be called after show();
                            }
                        };
                        new Thread(login, "CVS_AUTHORIZING_THREAD").start();
                    }
                });
            }
        });
        show();
    }
    
    private void checkLogin() {
        lastSuccessfullLoggings.remove(connectStr);
        passwordField.setEnabled(false);
        loginButton.setEnabled(false);
        setStatus(STATUS_CONNECTING, null);
        StringBuffer message = new StringBuffer();
        try {
            CVSPasswd pasFile = new CVSPasswd((String)null);
            pasFile.loadPassFile();
            password = new String(passwordField.getPassword());
            pasFile.remove(connectStr);
            pasFile.add(connectStr, password);
            loggedIn = CVSPasswd.checkLogin(fileSystem, message);
        } catch (java.net.UnknownHostException exc) {
            setStatus(org.openide.util.NbBundle.getBundle(CvsLoginDialog.class).getString("LoginDialog.unknownHost"));
            return;
        } catch (java.io.IOException exc) {
            setStatus(org.openide.util.NbBundle.getBundle(CvsLoginDialog.class).getString("LoginDialog.connectionIOError"));
            return;
        } finally {
            passwordField.setEnabled(true);
            loginButton.setEnabled(true);
        }
        if (!loggedIn) {
            setStatus(STATUS_FAILED, message.toString());
        } else {
            lastSuccessfullLoggings.add(connectStr);
            closeDialog(null);
        }
    }
    
    public void setConnectString(String connectStr) {
        this.connectStr = connectStr;
    }
    
    public void setPserverName(String pserverName) {
        loginLabel.setText(java.text.MessageFormat.format(org.openide.util.NbBundle.getBundle(CvsLoginDialog.class).getString("LoginDialog.loginLabel.text"), new Object[] { pserverName }));
        pack();
    }
    
    public void setStatus(Object status) {
        setStatus(status, null);
    }
    
    public void setStatus(Object status, String message) {
        if (status.equals(STATUS_FAILED)) {
            statusLabel.setText(org.openide.util.NbBundle.getBundle(CvsLoginDialog.class).getString("LoginDialog.status.failed"));
            if (message != null) statusLabel.setToolTipText(message);
        } else if (status.equals(STATUS_CONNECTING)) {
            statusLabel.setText(org.openide.util.NbBundle.getBundle(CvsLoginDialog.class).getString("LoginDialog.status.connecting"));
        } else if (status instanceof String) {
            statusLabel.setText((String) status);
        }
    }
    
    public boolean isLoggedIn() {
        return loggedIn;
    }
    
    public boolean isOffline() {
        return offline;
    }
    
    public String getPassword() {
        return password;
    }
    
    public static CvsLoginDialog createDialog(VcsFileSystem fileSystem) {
        CvsLoginDialog dialog = new CvsLoginDialog (new javax.swing.JFrame (), true);
        dialog.fileSystem = fileSystem;
        VcsUtilities.centerWindow(dialog);
        return dialog;
    }
    
    /**
     * @param args the command line arguments
     *
     * public static void main (String args[]) {
     * new LoginDialog (new javax.swing.JFrame (), true, null).show ();
     * }
     */
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPasswordField passwordField;
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JPanel loginPanel;
    private javax.swing.JPanel statusPanel;
    private javax.swing.JLabel loginLabel;
    private javax.swing.JLabel statusLabel;
    private javax.swing.JButton loginButton;
    private javax.swing.JLabel passwordLabel;
    private javax.swing.JButton offlineButton;
    // End of variables declaration//GEN-END:variables

    private static final long serialVersionUID = -1726365277738112132L;    

}
