/*
 *                 Sun Public License Notice
 * 
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 * 
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2001 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package vcs.commands;

import java.util.Hashtable;

import org.openide.*;

import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.commands.*;
import org.netbeans.modules.vcscore.cmdline.VcsAdditionalCommand;

import org.netbeans.modules.vcs.advanced.VcsCustomizer;

/**
 * This command invokes the customizer of the CVS filesystem.
 * @author  Martin Entlicher
 */
public class VCSCustomizerCommand implements VcsAdditionalCommand {

    private VcsFileSystem fileSystem = null;

    /** Creates new CvsCustomizer */
    public VCSCustomizerCommand() {
    }

    public void setFileSystem(VcsFileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public boolean exec(Hashtable vars, String[] args,
                        CommandOutputListener stdoutNRListener, CommandOutputListener stderrNRListener,
                        CommandDataOutputListener stdoutListener, String dataRegex,
                        CommandDataOutputListener stderrListener, String errorRegex) {
        VcsCustomizer cust = new VcsCustomizer();
        cust.setObject(fileSystem);
        DialogDescriptor dd = new DialogDescriptor (cust, org.openide.util.NbBundle.getBundle(VCSCustomizerCommand.class).getString("LAB_FS_Configuration"));
        TopManager.getDefault ().createDialog (dd).show ();
        return true;
    }
}
