@echo off
rem *** INSTALATOR MUST SET APPROPRIATE DIRECTORY ***
SET _IDE_HOME=..\..
rem *** INSTALATOR MUST SET APPROPRIATE DIRECTORY ***
SET JAVA_PATH=%JAVA_PATH%

if not exist %_IDE_HOME%\lib\core.jar goto NO_IDE

rem *** REMOVE THIS PART BEFORE ADDING TO INSTALLATOR
if %JAVA_PATH%. == . goto SET_JAVA
GOTO RUN
:SET_JAVA
SET JAVA_PATH=
:RUN
rem *** END OF PART TO REMOVE ***

:CHECK_ENV
if %JAVA_PATH%. == . goto NO_JAVA

rem Everything seems to be OK, lets go ...

:RESTART

SET EX_PATH=
SET PATCH_PATH=

IF not exist "%_IDE_HOME%\lib\patches" goto NO_PATCH

FOR %%f IN ( "%_IDE_HOME%\lib\patches\*.jar" ) DO CALL %_IDE_HOME%\bin\unsupported\add2path.bat "%%f" patch
FOR %%f IN ( "%_IDE_HOME%\lib\patches\*.zip" ) DO CALL %_IDE_HOME%\bin\unsupported\add2path.bat "%%f" patch

:NO_PATCH

IF not exist "%_IDE_HOME%\lib\ext" goto NO_EXT

FOR %%f IN ( "%_IDE_HOME%\lib\ext\*.jar" ) DO CALL %_IDE_HOME%\bin\unsupported\add2path.bat "%%f" ext
FOR %%f IN ( "%_IDE_HOME%\lib\ext\*.zip" ) DO CALL %_IDE_HOME%\bin\unsupported\add2path.bat "%%f" ext

:NO_EXT

SET IDE_CLASSPATH=%PATCH_PATH%;%_IDE_HOME%\lib\openide.jar;%_IDE_HOME%\lib\openide-fs.jar;%_IDE_HOME%\lib\openide-util.jar;%_IDE_HOME%\lib\core.jar;%EX_PATH%;%JAVA_PATH%\lib\dt.jar;%JAVA_PATH%\lib\tools.jar;%CLASSPATH%


%JAVA_PATH%\bin\java -classpath "%IDE_CLASSPATH%" -Djava.security.policy=%_IDE_HOME%\bin\ide.policy -Dnetbeans.home=%_IDE_HOME% -Xmx96m org.netbeans.Main

if errorlevel 67 goto END
if errorlevel 66 goto UPDATE

goto END

:UPDATE
%JAVA_PATH%\bin\java -classpath %_IDE_HOME%\lib\updater.jar -Dnetbeans.home=%_IDE_HOME% -Xmx96m org.netbeans.updater.UpdaterFrame
goto RESTART

:NO_IDE
echo Error: _IDE_HOME variable does not point to your
echo IDE installation. Please edit your startup script. 
pause
goto END

:NO_JAVA
echo Error: JAVA_PATH variable does not point to a Java 2
echo installation. Please edit your startup script.  
pause
goto END

:END
