/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import org.netbeans.lib.terminalemulator.Attr;
import org.netbeans.lib.terminalemulator.MyFontMetrics;
import org.netbeans.lib.terminalemulator.Term;

class Line {
    public int glyph_glyph;
    public int glyph_rendition;
    private char[] buf;
    private int[] attr;
    private int capacity;
    private int length;
    private boolean wrapped;
    private boolean about_to_wrap;

    public Line() {
        this.reset();
    }

    public void reset() {
        this.length = 0;
        this.capacity = 32;
        this.buf = new char[this.capacity];
        this.attr = null;
        this.glyph_glyph = 0;
        this.glyph_rendition = 0;
        this.wrapped = false;
        this.about_to_wrap = false;
    }

    public int capacity() {
        return this.capacity;
    }

    public int length() {
        return this.length;
    }

    public boolean hasAttributes() {
        return this.attr != null;
    }

    public void setWrapped(boolean bl) {
        this.wrapped = bl;
    }

    public boolean isWrapped() {
        return this.wrapped;
    }

    public boolean setAboutToWrap(boolean bl) {
        boolean bl2 = bl;
        this.about_to_wrap = bl;
        return bl2;
    }

    public boolean isAboutToWrap() {
        return this.about_to_wrap;
    }

    private boolean haveAttributes(int n) {
        if (this.attr == null && n != 0) {
            this.attr = new int[this.capacity];
        }
        return this.attr != null;
    }

    public char[] charArray() {
        return this.buf;
    }

    public int[] attrArray() {
        return this.attr;
    }

    public byte width(MyFontMetrics myFontMetrics, int n) {
        if (n >= this.capacity) {
            return 1;
        }
        return (byte)myFontMetrics.wcwidth(this.buf[n]);
    }

    public int cellToBuf(MyFontMetrics myFontMetrics, int n) {
        if (myFontMetrics.isMultiCell()) {
            byte by;
            int n2 = 0;
            int n3 = 0;
            while (n3 + (by = this.width(myFontMetrics, n2)) - 1 < n) {
                n3 += by;
                ++n2;
            }
            return n2;
        }
        return n;
    }

    public int bufToCell(MyFontMetrics myFontMetrics, int n) {
        if (myFontMetrics.isMultiCell()) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                n2 += this.width(myFontMetrics, n3);
                ++n3;
            }
            return n2;
        }
        return n;
    }

    public StringBuffer stringBuffer() {
        StringBuffer stringBuffer = new StringBuffer(this.length);
        return stringBuffer.append(this.buf, 0, this.length);
    }

    private void ensureCapacity(Term term, int n) {
        term.noteColumn(this, n);
        if (n <= this.capacity) {
            return;
        }
        int n2 = (this.length + 1) * 2;
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        } else if (n > n2) {
            n2 = n;
        }
        char[] cArray = new char[n2];
        System.arraycopy(this.buf, 0, cArray, 0, this.length);
        this.buf = cArray;
        if (this.attr != null) {
            int[] nArray = new int[n2];
            System.arraycopy(this.attr, 0, nArray, 0, this.length);
            this.attr = nArray;
        }
        this.capacity = n2;
    }

    public void insertCharAt(Term term, char c, int n, int n2) {
        int n3 = this.length + 1;
        this.ensureCapacity(term, n3);
        if (n >= this.length) {
            int n4 = this.length;
            while (n4 < n) {
                this.buf[n4] = 32;
                ++n4;
            }
        }
        System.arraycopy(this.buf, n, this.buf, n + 1, this.length - n);
        term.checkForMultiCell(c);
        this.buf[n] = c;
        if (this.haveAttributes(n2)) {
            System.arraycopy(this.attr, n, this.attr, n + 1, this.length - n);
            this.attr[n] = n2;
        }
        this.length = n3;
    }

    public void setCharAt(Term term, char c, int n, int n2) {
        if (n >= this.length) {
            this.ensureCapacity(term, n + 1);
            int n3 = this.length;
            while (n3 < n) {
                this.buf[n3] = 32;
                ++n3;
            }
            this.length = n + 1;
        }
        term.checkForMultiCell(c);
        this.buf[n] = c;
        if (this.haveAttributes(n2)) {
            this.attr[n] = n2;
        }
    }

    public void deleteCharAt(int n) {
        if (n < 0 || n >= this.length) {
            return;
        }
        System.arraycopy(this.buf, n + 1, this.buf, n, this.length - n - 1);
        this.buf[this.length - 1] = '\u0000';
        if (this.attr != null) {
            System.arraycopy(this.attr, n + 1, this.attr, n, this.length - n - 1);
            this.attr[this.length - 1] = 0;
        }
        --this.length;
    }

    public void clearToEndFrom(Term term, int n) {
        this.ensureCapacity(term, n + 1);
        int n2 = n;
        while (n2 < this.length) {
            this.buf[n2] = 32;
            ++n2;
        }
        if (this.attr != null) {
            int n3 = n;
            while (n3 < this.length) {
                this.attr[n3] = 32;
                ++n3;
            }
        }
        this.length = n;
    }

    public String text(int n, int n2) {
        String string = "";
        if (this.length == 0) {
            return "";
        }
        if (n2 >= this.length) {
            n2 = this.length - 1;
            string = "\n";
            if (n >= this.length) {
                n = this.length - 1;
            }
        }
        return new String(this.buf, n, n2 - n + 1) + string;
    }

    public void setCharacterAttribute(int n, int n2, int n3, boolean bl) {
        if (!this.haveAttributes(n3)) {
            return;
        }
        if (bl) {
            int n4 = n;
            while (n4 <= n2) {
                this.attr[n4] = Attr.setAttribute(this.attr[n4], n3);
                ++n4;
            }
        } else {
            int n5 = n;
            while (n5 <= n2) {
                this.attr[n5] = Attr.unsetAttribute(this.attr[n5], n3);
                ++n5;
            }
        }
    }
}

