/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

class Attr {
    private static final int BGCOLORf = 0;
    private static final int BGCOLORw = 5;
    private static final int BGCOLORm = 15;
    public static final int BGCOLOR = 15;
    private static final int FGCOLORf = 5;
    private static final int FGCOLORw = 5;
    private static final int FGCOLORm = 15;
    public static final int FGCOLOR = 480;
    private static final int HIDDENf = 10;
    private static final int HIDDENw = 1;
    public static final int HIDDEN = 1024;
    private static final int REVERSEf = 11;
    private static final int REVERSEw = 1;
    public static final int REVERSE = 2048;
    private static final int BLINKf = 12;
    private static final int BLINKw = 1;
    public static final int BLINK = 4096;
    private static final int UNDERSCOREf = 13;
    private static final int UNDERSCOREw = 1;
    public static final int UNDERSCORE = 8192;
    private static final int BRIGHTf = 14;
    private static final int BRIGHTw = 1;
    public static final int BRIGHT = 16384;
    private static final int DIMf = 15;
    private static final int DIMw = 1;
    public static final int DIM = 32768;
    private static final int ACTIVEf = 16;
    private static final int ACTIVEw = 1;
    public static final int ACTIVE = 65536;
    public static final int UNSET = 0x40000000;

    Attr() {
    }

    public static int setBackgroundColor(int n, int n2) {
        n &= 0xFFFFFFF0;
        return n |= (n2 &= 0xF) << 0;
    }

    public static int setForegroundColor(int n, int n2) {
        n &= 0xFFFFFE1F;
        return n |= (n2 &= 0xF) << 5;
    }

    public static int foregroundColor(int n) {
        return n >> 5 & 0xF;
    }

    public static int backgroundColor(int n) {
        return n >> 0 & 0xF;
    }

    public static int setAttribute(int n, int n2) {
        switch (n2) {
            case 0: {
                n = 0;
                break;
            }
            case 1: 
            case 5: {
                n &= 0xFFFF7FFF;
                n |= 0x4000;
                break;
            }
            case 2: {
                n &= 0xFFFFBFFF;
                n |= 0x8000;
                break;
            }
            case 4: {
                n |= 0x2000;
                break;
            }
            case 7: {
                n |= 0x800;
                break;
            }
            case 8: {
                n |= 0x400;
                break;
            }
            case 9: {
                n |= 0x10000;
                break;
            }
            case 22: 
            case 25: {
                n &= 0xFFFF7FFF;
                n &= 0xFFFFBFFF;
                break;
            }
            case 24: {
                n &= 0xFFFFDFFF;
                break;
            }
            case 27: {
                n &= 0xFFFFF7FF;
                break;
            }
            case 28: {
                n &= 0xFFFFFBFF;
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                n = Attr.setForegroundColor(n, n2 - 30 + 1);
                break;
            }
            case 39: {
                n = Attr.setForegroundColor(n, 0);
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                n = Attr.setBackgroundColor(n, n2 - 40 + 1);
                break;
            }
            case 49: {
                n = Attr.setBackgroundColor(n, 0);
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                n = Attr.setForegroundColor(n, n2 - 50 + 9);
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                n = Attr.setBackgroundColor(n, n2 - 60 + 9);
                break;
            }
        }
        return n;
    }

    public static int unsetAttribute(int n, int n2) {
        switch (n2) {
            case 0: {
                n = 0;
                break;
            }
            case 1: 
            case 5: {
                n &= 0xFFFFBFFF;
                break;
            }
            case 2: {
                n &= 0xFFFF7FFF;
                break;
            }
            case 4: {
                n &= 0xFFFFDFFF;
                break;
            }
            case 7: {
                n &= 0xFFFFF7FF;
                break;
            }
            case 8: {
                n &= 0xFFFFFBFF;
                break;
            }
            case 9: {
                n &= 0xFFFEFFFF;
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                n = Attr.setForegroundColor(n, 0);
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                n = Attr.setBackgroundColor(n, 0);
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                n = Attr.setForegroundColor(n, 0);
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                n = Attr.setBackgroundColor(n, 0);
                break;
            }
        }
        return n;
    }
}

