/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import org.netbeans.lib.terminalemulator.ActiveRegion;
import org.netbeans.lib.terminalemulator.ActiveTermListener;
import org.netbeans.lib.terminalemulator.BCoord;
import org.netbeans.lib.terminalemulator.Coord;
import org.netbeans.lib.terminalemulator.RegionException;
import org.netbeans.lib.terminalemulator.RegionManager;
import org.netbeans.lib.terminalemulator.StreamTerm;

public class ActiveTerm
extends StreamTerm {
    private ActiveTermListener at_listener;
    private RegionManager rm;
    private Coord last_begin = null;
    private Coord last_end = null;

    public ActiveTerm() {
        this.setCursorVisible(false);
        this.rm = this.regionManager();
        this.getCanvas().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 0x10) != 16) {
                    return;
                }
                Point point = ActiveTerm.this.mapToBufRowCol(mouseEvent.getPoint());
                BCoord bCoord = new BCoord(point.y, point.x);
                Coord coord = new Coord(bCoord, ActiveTerm.this.firsta);
                ActiveRegion activeRegion = ActiveTerm.this.rm.findRegion(coord);
                if (activeRegion == null) {
                    // empty if block
                }
                if (activeRegion != null) {
                    if (activeRegion.isSelectable()) {
                        ActiveTerm.this.setSelectionExtent(activeRegion.getExtent());
                    }
                    if (ActiveTerm.this.at_listener != null) {
                        ActiveTerm.this.at_listener.action(activeRegion, mouseEvent);
                    }
                }
            }
        });
        this.getCanvas().addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                Point point = ActiveTerm.this.mapToBufRowCol(mouseEvent.getPoint());
                BCoord bCoord = new BCoord(point.y, point.x);
                Coord coord = new Coord(bCoord, ActiveTerm.this.firsta);
                ActiveRegion activeRegion = ActiveTerm.this.rm.findRegion(coord);
                ActiveRegion activeRegion2 = ActiveTerm.this.findRegionToHilite(activeRegion);
                if (activeRegion2 == null) {
                    ActiveTerm.this.hilite(null, null);
                } else {
                    ActiveTerm.this.hilite(activeRegion2.begin, activeRegion2.end);
                }
            }
        });
    }

    private ActiveRegion findRegionToHilite(ActiveRegion activeRegion) {
        if (activeRegion == null) {
            return null;
        }
        if (activeRegion.isFeedbackEnabled()) {
            return activeRegion;
        }
        if (activeRegion.isFeedbackViaParent()) {
            return this.findRegionToHilite(activeRegion.parent());
        }
        return null;
    }

    public void setActionListener(ActiveTermListener activeTermListener) {
        this.at_listener = activeTermListener;
    }

    private void hilite_help(Coord coord, Coord coord2, boolean bl) {
        if (coord == null && coord2 == null) {
            return;
        }
        this.setCharacterAttribute(coord, coord2, 9, bl);
    }

    public void hilite(Coord coord, Coord coord2) {
        if (coord2 != null && coord2.row == 1 && coord2.col == 0) {
            coord2 = this.getCursorCoord();
        }
        this.hilite_help(this.last_begin, this.last_end, false);
        this.last_begin = coord == null ? null : (Coord)coord.clone();
        this.last_end = coord2 == null ? null : (Coord)coord2.clone();
        this.hilite_help(coord, coord2, true);
    }

    public void hilite(ActiveRegion activeRegion) {
        this.hilite(activeRegion.begin, activeRegion.end);
    }

    public ActiveRegion beginRegion(boolean bl) {
        ActiveRegion activeRegion = null;
        try {
            activeRegion = this.rm.beginRegion(this.getCursorCoord());
        }
        catch (RegionException regionException) {
            // empty catch block
        }
        if (bl) {
            this.setAttribute(34);
            this.setAttribute(4);
        }
        return activeRegion;
    }

    public void endRegion() {
        Coord coord = this.getCursorCoord();
        Coord coord2 = this.backup(coord);
        if (coord2 == null) {
            coord2 = coord;
        }
        try {
            this.rm.endRegion(coord2);
        }
        catch (RegionException regionException) {
            // empty catch block
        }
        this.setAttribute(0);
    }

    public ActiveRegion findRegion(Coord coord) {
        return this.rm.findRegion(coord);
    }

    public void cancelRegion() {
        try {
            this.rm.cancelRegion();
        }
        catch (RegionException regionException) {
            // empty catch block
        }
    }

    public void clear() {
        this.nullLasts();
        super.clear();
    }

    public void clearHistoryNoRefresh() {
        this.nullLasts();
        super.clearHistoryNoRefresh();
    }

    private void nullLasts() {
        this.last_begin = null;
        this.last_end = null;
    }
}

