/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import java.util.LinkedList;
import java.util.ListIterator;
import org.netbeans.lib.terminalemulator.Coord;
import org.netbeans.lib.terminalemulator.Extent;

public class ActiveRegion {
    public Coord begin = new Coord();
    public Coord end = new Coord();
    ActiveRegion parent;
    boolean nested;
    private LinkedList children;
    private boolean has_end;
    private boolean selectable;
    private boolean feedback_enabled;
    private boolean feedback_via_parent;
    private boolean link;
    private Object user_object;

    ActiveRegion(ActiveRegion activeRegion, Coord coord, boolean bl) {
        this.parent = activeRegion;
        this.begin.copyFrom(coord);
        this.nested = bl;
    }

    public ActiveRegion parent() {
        return this.parent;
    }

    public Extent getExtent() {
        if (this.has_end) {
            return new Extent(this.begin, this.end);
        }
        return new Extent(this.begin, this.begin);
    }

    void setEnd(Coord coord) {
        this.end.copyFrom(coord);
        this.has_end = true;
    }

    void addChild(ActiveRegion activeRegion) {
        if (this.children == null) {
            this.children = new LinkedList();
        }
        this.children.add(activeRegion);
    }

    void removeChild(ActiveRegion activeRegion) {
        if (this.children == null) {
            return;
        }
        this.children.remove(activeRegion);
    }

    ActiveRegion contains(Coord coord) {
        boolean bl;
        boolean bl2 = bl = this.has_end && coord.compareTo(this.end) > 0;
        if (this.parent != null && (coord.compareTo(this.begin) < 0 || bl)) {
            return null;
        }
        if (this.children != null) {
            ListIterator listIterator = this.children.listIterator();
            while (listIterator.hasNext()) {
                ActiveRegion activeRegion = (ActiveRegion)listIterator.next();
                if (coord.compareTo(activeRegion.begin) < 0) break;
                ActiveRegion activeRegion2 = activeRegion.contains(coord);
                if (activeRegion2 == null) continue;
                return activeRegion2;
            }
        }
        return this;
    }

    void relocate(int n) {
        this.begin.row += n;
        this.end.row += n;
        if (this.children != null) {
            ListIterator listIterator = this.children.listIterator();
            while (listIterator.hasNext()) {
                ActiveRegion activeRegion = (ActiveRegion)listIterator.next();
                activeRegion.relocate(n);
            }
        }
    }

    void cull(int n) {
        if (this.children == null) {
            return;
        }
        int n2 = 0;
        ListIterator listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            ActiveRegion activeRegion = (ActiveRegion)listIterator.next();
            if (activeRegion.begin.row >= n) break;
            listIterator.remove();
            ++n2;
        }
    }

    public void setSelectable(boolean bl) {
        this.selectable = bl;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setFeedbackEnabled(boolean bl) {
        this.feedback_enabled = bl;
    }

    public boolean isFeedbackEnabled() {
        return this.feedback_enabled;
    }

    public void setFeedbackViaParent(boolean bl) {
        this.feedback_via_parent = bl;
    }

    public boolean isFeedbackViaParent() {
        return this.feedback_via_parent;
    }

    public void setLink(boolean bl) {
        this.link = bl;
    }

    public boolean isLink() {
        return this.link;
    }

    public void setUserObject(Object object) {
        this.user_object = object;
    }

    public Object getUserObject() {
        return this.user_object;
    }

    public ActiveRegion firstChild() {
        if (this.children == null) {
            return null;
        }
        return (ActiveRegion)this.children.getFirst();
    }

    public ActiveRegion getPreviousSibling() {
        if (this.parent != null) {
            return this.parent.previous_sibling_of(this);
        }
        return null;
    }

    public ActiveRegion getNextSibling() {
        if (this.parent != null) {
            return this.parent.next_sibling_of(this);
        }
        return null;
    }

    private ActiveRegion previous_sibling_of(ActiveRegion activeRegion) {
        ListIterator listIterator = this.children.listIterator();
        ActiveRegion activeRegion2 = null;
        while (listIterator.hasNext()) {
            ActiveRegion activeRegion3 = (ActiveRegion)listIterator.next();
            if (activeRegion3 == activeRegion) {
                return activeRegion2;
            }
            activeRegion2 = activeRegion3;
        }
        return null;
    }

    private ActiveRegion next_sibling_of(ActiveRegion activeRegion) {
        ListIterator listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            ActiveRegion activeRegion2 = (ActiveRegion)listIterator.next();
            if (activeRegion2 != activeRegion) continue;
            return listIterator.hasNext() ? listIterator.next() : null;
        }
        return null;
    }
}

