/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.beaninfo;

import java.io.IOException;
import org.netbeans.modules.java.JavaEditor;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.src.ClassElement;
import org.openide.src.SourceElement;

public class BeanInfoSource {
    private static final String BEANINFO_NAME_EXT = "BeanInfo";
    private static final String BEANINFONOICON_NAME_EXT = "BeanInfoNoIcon";
    private static final String DESCRIPTOR_SECTION = "BeanDescriptor";
    private static final String PROPERTIES_SECTION = "Properties";
    private static final String EVENTSETS_SECTION = "Events";
    private static final String ICONS_SECTION = "Icons";
    private static final String IDX_SECTION = "Idx";
    private static final String METHODS_SECTION = "Methods";
    private static final String SUPERCLASS_SECTION = "Superclass";
    private ClassElement classElement;
    private DataObject biDataObject = null;
    private JavaEditor javaEditor = null;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$netbeans$modules$java$JavaEditor;

    public BeanInfoSource(ClassElement classElement) {
        this.classElement = classElement;
        this.findBeanInfo();
    }

    boolean exists() {
        return this.biDataObject != null;
    }

    boolean isNbBeanInfo() {
        if (!this.exists() || this.javaEditor == null) {
            return false;
        }
        JavaEditor.InteriorSection interiorSection = this.javaEditor.findInteriorSection(PROPERTIES_SECTION);
        JavaEditor.InteriorSection interiorSection2 = this.javaEditor.findInteriorSection(EVENTSETS_SECTION);
        JavaEditor.InteriorSection interiorSection3 = this.javaEditor.findInteriorSection(METHODS_SECTION);
        JavaEditor.SimpleSection simpleSection = this.javaEditor.findSimpleSection(IDX_SECTION);
        return interiorSection != null && interiorSection2 != null && simpleSection != null;
    }

    boolean hasIconInfo() {
        JavaEditor.SimpleSection simpleSection = this.javaEditor.findSimpleSection(ICONS_SECTION);
        return simpleSection != null;
    }

    boolean isNbBeanInfoDescriptor() {
        if (!this.exists() || this.javaEditor == null) {
            return false;
        }
        JavaEditor.InteriorSection interiorSection = this.javaEditor.findInteriorSection(DESCRIPTOR_SECTION);
        return interiorSection != null;
    }

    boolean isNbSuperclass() {
        if (!this.exists() || this.javaEditor == null) {
            return false;
        }
        JavaEditor.InteriorSection interiorSection = this.javaEditor.findInteriorSection(SUPERCLASS_SECTION);
        return interiorSection != null;
    }

    void findBeanInfo() {
        this.javaEditor = null;
        SourceElement sourceElement = this.classElement.getSource();
        if (sourceElement == null) {
            return;
        }
        DataObject dataObject = (DataObject)sourceElement.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = BeanInfoSource.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
        if (dataObject == null) {
            return;
        }
        FileObject fileObject = dataObject.getFolder().getPrimaryFile();
        if (fileObject == null) {
            return;
        }
        FileObject fileObject2 = fileObject.getFileObject(dataObject.getName() + BEANINFO_NAME_EXT, "java");
        if (fileObject2 == null) {
            return;
        }
        try {
            this.biDataObject = DataObject.find((FileObject)fileObject2);
            this.javaEditor = (JavaEditor)this.biDataObject.getCookie(class$org$netbeans$modules$java$JavaEditor == null ? (class$org$netbeans$modules$java$JavaEditor = BeanInfoSource.class$("org.netbeans.modules.java.JavaEditor")) : class$org$netbeans$modules$java$JavaEditor);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
    }

    void delete() throws IOException {
        this.biDataObject.delete();
    }

    void createFromTemplate(boolean bl) {
        DataFolder dataFolder = TopManager.getDefault().getPlaces().folders().templates();
        if (dataFolder == null) {
            return;
        }
        FileObject fileObject = dataFolder.getPrimaryFile();
        if (fileObject == null) {
            return;
        }
        FileObject fileObject2 = fileObject.getFileObject("Beans");
        if (fileObject2 == null) {
            return;
        }
        FileObject fileObject3 = null;
        fileObject3 = bl ? fileObject2.getFileObject(BEANINFO_NAME_EXT, "java") : fileObject2.getFileObject(BEANINFONOICON_NAME_EXT, "java");
        if (fileObject3 == null) {
            return;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject3);
            SourceElement sourceElement = this.classElement.getSource();
            if (sourceElement == null) {
                return;
            }
            DataObject dataObject2 = (DataObject)sourceElement.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = BeanInfoSource.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            if (dataObject2 == null) {
                return;
            }
            DataFolder dataFolder2 = dataObject2.getFolder();
            this.biDataObject = dataObject.createFromTemplate(dataFolder2, dataObject2.getName() + BEANINFO_NAME_EXT);
            this.javaEditor = (JavaEditor)this.biDataObject.getCookie(class$org$netbeans$modules$java$JavaEditor == null ? (class$org$netbeans$modules$java$JavaEditor = BeanInfoSource.class$("org.netbeans.modules.java.JavaEditor")) : class$org$netbeans$modules$java$JavaEditor);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    DataObject getDataObject() {
        return this.biDataObject;
    }

    void open() {
        this.javaEditor.open();
    }

    void setDescriptorSection(String string, String string2) {
        JavaEditor.InteriorSection interiorSection = this.javaEditor.findInteriorSection(DESCRIPTOR_SECTION);
        if (interiorSection != null) {
            interiorSection.setHeader(string);
            interiorSection.setBottom(string2);
        }
    }

    String getDescriptorSection() {
        JavaEditor.InteriorSection interiorSection = this.javaEditor.findInteriorSection(DESCRIPTOR_SECTION);
        if (interiorSection != null) {
            return interiorSection.getText();
        }
        return null;
    }

    void setPropertiesSection(String string, String string2) {
        JavaEditor.InteriorSection interiorSection = this.javaEditor.findInteriorSection(PROPERTIES_SECTION);
        if (interiorSection != null) {
            interiorSection.setHeader(string);
            interiorSection.setBottom(string2);
        }
    }

    String getPropertiesSection() {
        JavaEditor.InteriorSection interiorSection = this.javaEditor.findInteriorSection(PROPERTIES_SECTION);
        if (interiorSection != null) {
            return interiorSection.getText();
        }
        return null;
    }

    void setMethodsSection(String string, String string2) {
        JavaEditor.InteriorSection interiorSection = this.javaEditor.findInteriorSection(METHODS_SECTION);
        if (interiorSection != null) {
            interiorSection.setHeader(string);
            interiorSection.setBottom(string2);
        }
    }

    String getMethodsSection() {
        JavaEditor.InteriorSection interiorSection = this.javaEditor.findInteriorSection(METHODS_SECTION);
        if (interiorSection != null) {
            return interiorSection.getText();
        }
        return null;
    }

    void setEventSetsSection(String string, String string2) {
        JavaEditor.InteriorSection interiorSection = this.javaEditor.findInteriorSection(EVENTSETS_SECTION);
        if (interiorSection != null) {
            interiorSection.setHeader(string);
            interiorSection.setBottom(string2);
        }
    }

    String getEventSetsSection() {
        JavaEditor.InteriorSection interiorSection = this.javaEditor.findInteriorSection(EVENTSETS_SECTION);
        if (interiorSection != null) {
            return interiorSection.getText();
        }
        return null;
    }

    String getIconsSection() {
        JavaEditor.SimpleSection simpleSection = this.javaEditor.findSimpleSection(ICONS_SECTION);
        if (simpleSection != null) {
            return simpleSection.getText();
        }
        return null;
    }

    void setIconsSection(String string) {
        JavaEditor.SimpleSection simpleSection = this.javaEditor.findSimpleSection(ICONS_SECTION);
        if (simpleSection != null) {
            simpleSection.setText(string);
        }
    }

    String getDefaultIdxSection() {
        JavaEditor.SimpleSection simpleSection = this.javaEditor.findSimpleSection(IDX_SECTION);
        if (simpleSection != null) {
            return simpleSection.getText();
        }
        return null;
    }

    void setDefaultIdxSection(String string) {
        JavaEditor.SimpleSection simpleSection = this.javaEditor.findSimpleSection(IDX_SECTION);
        if (simpleSection != null) {
            simpleSection.setText(string);
        }
    }

    void setSuperclassSection(String string, String string2) {
        JavaEditor.InteriorSection interiorSection = this.javaEditor.findInteriorSection(SUPERCLASS_SECTION);
        if (interiorSection != null) {
            interiorSection.setHeader(string);
            interiorSection.setBottom(string2);
        }
    }

    String getSuperclassSection() {
        JavaEditor.InteriorSection interiorSection = this.javaEditor.findInteriorSection(SUPERCLASS_SECTION);
        if (interiorSection != null) {
            return interiorSection.getText();
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

