/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.util;

import org.openide.util.RequestProcessor;

public class RequestSynchronizer {
    Integer LOCK = new Integer(0);
    Thread requestorThread = null;
    RequestProcessor processor = new RequestProcessor();
    RequestProcessor.Task task;
    long lastStart;
    boolean releaseOn = false;

    public synchronized void postRequest(final Runnable runnable, boolean bl) {
        if (this.releaseOn) {
            return;
        }
        Integer n = this.LOCK;
        synchronized (n) {
            if (this.requestorThread != null) {
                try {
                    this.LOCK.wait();
                    if (this.releaseOn) {
                        return;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.requestorThread = new Thread("Request " + runnable + " thread"){

                public void run() {
                    Integer n = RequestSynchronizer.this.LOCK;
                    synchronized (n) {
                        RequestSynchronizer.this.lastStart = System.currentTimeMillis();
                        try {
                            runnable.run();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        RequestSynchronizer.this.requestorThread = null;
                        RequestSynchronizer.this.LOCK.notify();
                    }
                }
            };
            this.requestorThread.start();
            try {
                if (bl) {
                    this.LOCK.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void postRequest(Runnable runnable) {
        this.postRequest(runnable, false);
    }

    public synchronized void postRequestAndWait(Runnable runnable) {
        this.postRequest(runnable, true);
    }

    public synchronized void postRequest(Runnable runnable, int n) {
        this.postRequest(runnable, n, new RequestWaiter(){

            public void run(Thread thread) {
                RequestSynchronizer.this.requestorThread.interrupt();
                RequestSynchronizer.this.requestorThread.stop();
            }
        });
    }

    public synchronized void postRequestAndWait(Runnable runnable, int n) {
        this.postRequest(runnable, n, new RequestWaiter(){

            public void run(Thread thread) {
                RequestSynchronizer.this.requestorThread.interrupt();
                RequestSynchronizer.this.requestorThread.stop();
            }
        });
    }

    public synchronized void postRequest(Runnable runnable, int n, final RequestWaiter requestWaiter) {
        if (this.releaseOn) {
            return;
        }
        this.postRequest(runnable);
        final Thread thread = this.requestorThread;
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                if (RequestSynchronizer.this.requestorThread == null) {
                    return;
                }
                if (thread == RequestSynchronizer.this.requestorThread) {
                    long l = System.currentTimeMillis() - RequestSynchronizer.this.lastStart;
                    requestWaiter.run(RequestSynchronizer.this.requestorThread);
                }
            }
        }, (int)n);
    }

    public synchronized void postRequestAndWait(Runnable runnable, int n, final RequestWaiter requestWaiter) {
        if (this.releaseOn) {
            return;
        }
        Integer n2 = this.LOCK;
        synchronized (n2) {
            this.postRequest(runnable);
            final Thread thread = this.requestorThread;
            if (this.task != null) {
                this.task.cancel();
            }
            this.task = RequestProcessor.postRequest((Runnable)new Runnable(){

                public void run() {
                    if (RequestSynchronizer.this.requestorThread == null) {
                        return;
                    }
                    if (thread == RequestSynchronizer.this.requestorThread) {
                        long l = System.currentTimeMillis() - RequestSynchronizer.this.lastStart;
                        requestWaiter.run(RequestSynchronizer.this.requestorThread);
                    }
                }
            }, (int)n);
            try {
                this.LOCK.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void releaseAll() {
        this.releaseOn = true;
        if (this.requestorThread != null) {
            this.requestorThread.interrupt();
            this.requestorThread.stop();
        }
    }

    public static interface RequestWaiter {
        public void run(Thread var1);
    }
}

