/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ResourceBundle;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.Validator;
import org.netbeans.modules.debugger.ValidatorHolder;
import org.netbeans.modules.debugger.delegator.DelegatingWatch;
import org.netbeans.modules.debugger.support.actions.DeleteAllCookie;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.openide.TopManager;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.Watch;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public final class WatchesRootNode
extends AbstractNode
implements DeleteAllCookie {
    static final long serialVersionUID = -3518528079657369038L;
    private static final String ICON_WATCHES = "/org/netbeans/core/resources/watches";
    private static final String ICON_PENDING_WATCHES = "/org/netbeans/modules/debugger/resources/pendingWatches";
    private static SystemAction[] staticActions;
    private static ResourceBundle bundle;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$nodes$WatchesRootNode;
    static /* synthetic */ Class class$org$openide$actions$AddWatchAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$DeleteAllAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;

    static String getLocalizedString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$nodes$WatchesRootNode == null ? (class$org$netbeans$modules$debugger$support$nodes$WatchesRootNode = WatchesRootNode.class$("org.netbeans.modules.debugger.support.nodes.WatchesRootNode")) : class$org$netbeans$modules$debugger$support$nodes$WatchesRootNode));
        }
        return bundle.getString(string);
    }

    public WatchesRootNode() {
        super((Children)new WatchesRootChildren());
        String string = WatchesRootNode.getLocalizedString("CTL_Watches_group_root");
        this.setDisplayName(string);
        this.setName(string);
        this.setIconBase(ICON_WATCHES);
        this.getCookieSet().add((Node.Cookie)this);
        this.init();
    }

    private void init() {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, NotActiveException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    public Node.Handle getHandle() {
        return new WatchesHandle();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerWatchesRootNode");
    }

    public SystemAction[] getActions() {
        if (staticActions == null) {
            staticActions = new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$AddWatchAction == null ? (class$org$openide$actions$AddWatchAction = WatchesRootNode.class$("org.openide.actions.AddWatchAction")) : class$org$openide$actions$AddWatchAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$DeleteAllAction == null ? (class$org$netbeans$modules$debugger$support$actions$DeleteAllAction = WatchesRootNode.class$("org.netbeans.modules.debugger.support.actions.DeleteAllAction")) : class$org$netbeans$modules$debugger$support$actions$DeleteAllAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = WatchesRootNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = WatchesRootNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }
        return staticActions;
    }

    public SystemAction getDefaultAction() {
        return SystemAction.get((Class)(class$org$openide$actions$AddWatchAction == null ? (class$org$openide$actions$AddWatchAction = WatchesRootNode.class$("org.openide.actions.AddWatchAction")) : class$org$openide$actions$AddWatchAction));
    }

    public void deleteAll() {
        try {
            Debugger debugger = TopManager.getDefault().getDebugger();
            debugger.removeAllWatches();
            WatchesRootChildren watchesRootChildren = (WatchesRootChildren)this.getChildren();
            watchesRootChildren.removeAllVariables();
        }
        catch (DebuggerException debuggerException) {
            // empty catch block
        }
    }

    public void createVariable(AbstractVariable abstractVariable) {
        ((WatchesRootChildren)this.getChildren()).addVariable(abstractVariable);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class WatchesHandle
    implements Node.Handle {
        static final long serialVersionUID = -4518262478987259653L;

        private WatchesHandle() {
        }

        public Node getNode() {
            return new WatchesRootNode();
        }
    }

    static class DelegatingNode
    extends FilterNode {
        DelegatingWatch dw;

        private DelegatingNode(Node node, DelegatingWatch delegatingWatch) {
            super(node);
            this.dw = delegatingWatch;
        }

        public void destroy() {
            this.dw.remove();
        }
    }

    static class WRListener
    implements PropertyChangeListener {
        private Debugger debugger;
        private WeakReference node;
        private Watch[] watches = new Watch[0];

        WRListener(WatchesRootNode watchesRootNode, Debugger debugger) {
            this.debugger = debugger;
            this.node = new WeakReference<WatchesRootNode>(watchesRootNode);
            debugger.addPropertyChangeListener((PropertyChangeListener)this);
            if (debugger instanceof ValidatorHolder) {
                Validator validator = ((ValidatorHolder)debugger).getValidator();
                validator.addPropertyChangeListener(this);
            }
            this.setWatches(watchesRootNode);
        }

        WatchesRootNode getNode() {
            WatchesRootNode watchesRootNode = (WatchesRootNode)this.node.get();
            if (watchesRootNode != null) {
                return watchesRootNode;
            }
            this.destroy();
            return null;
        }

        void destroy() {
            this.debugger.removePropertyChangeListener((PropertyChangeListener)this);
            if (this.debugger instanceof ValidatorHolder) {
                Validator validator = ((ValidatorHolder)this.debugger).getValidator();
                validator.removePropertyChangeListener(this);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            WatchesRootNode watchesRootNode = this.getNode();
            if (watchesRootNode == null) {
                return;
            }
            if (propertyChangeEvent.getSource() instanceof Validator) {
                watchesRootNode.setIconBase(((Validator)propertyChangeEvent.getSource()).isValidated() ? WatchesRootNode.ICON_WATCHES : WatchesRootNode.ICON_PENDING_WATCHES);
                return;
            }
            if (propertyChangeEvent.getPropertyName() == null) {
                return;
            }
            if (propertyChangeEvent.getPropertyName().equals("state")) {
                if (this.debugger.getState() == 1) {
                    ((WatchesRootChildren)watchesRootNode.getChildren()).removeAllVariables();
                }
            }
            if (propertyChangeEvent.getPropertyName().equals("watches")) {
                this.setWatches(watchesRootNode);
            } else if (propertyChangeEvent.getPropertyName().equals("innerWatch")) {
                this.refreshWatches(watchesRootNode, (Watch)propertyChangeEvent.getSource());
            }
        }

        void refreshWatches(WatchesRootNode watchesRootNode, Watch watch) {
            ((WatchesRootChildren)watchesRootNode.getChildren()).refreshHelper(watch);
        }

        synchronized void setWatches(WatchesRootNode watchesRootNode) {
            int n = this.watches.length;
            int n2 = 0;
            while (n2 < n) {
                this.watches[n2].removePropertyChangeListener((PropertyChangeListener)this);
                ++n2;
            }
            this.watches = this.debugger.getWatches();
            ((WatchesRootChildren)watchesRootNode.getChildren()).set(this.watches);
            n = this.watches.length;
            n2 = 0;
            while (n2 < n) {
                this.watches[n2].addPropertyChangeListener((PropertyChangeListener)this);
                ++n2;
            }
        }
    }

    static final class WatchesRootChildren
    extends Children.Keys {
        private ArrayList variables = new ArrayList();
        private WRListener l;

        WatchesRootChildren() {
        }

        protected Node[] createNodes(Object object) {
            Node node;
            Watch watch;
            if (object instanceof Watch && ((Watch)object).isHidden()) {
                return new Node[0];
            }
            if (object instanceof DelegatingWatch && (watch = ((DelegatingWatch)object).getInnerWatch()) != null && (node = DebuggerNode.createNode(watch)) != null) {
                return new Node[]{new DelegatingNode(node, (DelegatingWatch)object)};
            }
            watch = null;
            watch = !(object instanceof Watch) ? DebuggerNode.createNode(object, new Object[]{new Integer(2)}) : DebuggerNode.createNode(object);
            if (watch == null) {
                return new Node[0];
            }
            return new Node[]{watch};
        }

        protected void addNotify() {
            try {
                Debugger debugger = TopManager.getDefault().getDebugger();
                this.l = new WRListener((WatchesRootNode)this.getNode(), debugger);
            }
            catch (DebuggerException debuggerException) {
                // empty catch block
            }
        }

        protected void removeNotify() {
            this.l.destroy();
            this.l = null;
            this.setKeys(Collections.EMPTY_SET);
        }

        void addVariable(AbstractVariable abstractVariable) {
            Node node = DebuggerNode.createNode(abstractVariable, new Object[]{abstractVariable, new Integer(2)});
            if (node != null) {
                this.variables.add(node);
                this.add(new Node[]{node});
            }
        }

        void refreshHelper(Watch watch) {
            this.refreshKey(watch);
        }

        void set(Object[] objectArray) {
            try {
                this.setKeys(objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        void removeAllVariables() {
            if (this.variables.size() < 1) {
                return;
            }
            Node[] nodeArray = new Node[this.variables.size()];
            nodeArray = this.variables.toArray(nodeArray);
            this.remove(nodeArray);
        }
    }
}

