/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.ResourceBundle;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.CallStackProducer;
import org.netbeans.modules.debugger.Location;
import org.netbeans.modules.debugger.VariablesProducer;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.netbeans.modules.debugger.support.nodes.LeafRefresher;
import org.netbeans.modules.debugger.support.nodes.ThreadNode;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class LocalsRootNode
extends AbstractNode
implements ThreadNode.Refreshable {
    static final long serialVersionUID = -6346315017458451778L;
    private static String ICON_BASE = "/org/netbeans/core/resources/watches";
    private static ResourceBundle bundle;
    private AbstractThread thread;
    private LocalsListener localsListener;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$nodes$LocalsRootNode;

    static String getLocalizedString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$nodes$LocalsRootNode == null ? (class$org$netbeans$modules$debugger$support$nodes$LocalsRootNode = LocalsRootNode.class$("org.netbeans.modules.debugger.support.nodes.LocalsRootNode")) : class$org$netbeans$modules$debugger$support$nodes$LocalsRootNode));
        }
        return bundle.getString(string);
    }

    public LocalsRootNode(AbstractThread abstractThread) {
        super((Children)new LocalsRootChildren());
        this.thread = abstractThread;
        String string = LocalsRootNode.getLocalizedString("CTL_Locals");
        this.setDisplayName(string);
        this.setName(string);
        this.setIconBase(ICON_BASE);
        this.localsListener = new LocalsListener(this);
        abstractThread.addPropertyChangeListener(this.localsListener);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerLocalsRootNode");
    }

    public void refresh() {
        String string = ((VariablesProducer)((Object)this.thread)).getInfo();
        string = string != null ? LocalsRootNode.getLocalizedString("CTL_Locals") + " (" + string + ')' : LocalsRootNode.getLocalizedString("CTL_Locals");
        this.setDisplayName(string);
        this.setName(string);
        ((LocalsRootChildren)this.getChildren()).changeChildren();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class LocalsListener
    implements PropertyChangeListener {
        private WeakReference node;
        private AbstractThread thread;

        LocalsListener(LocalsRootNode localsRootNode) {
            this.node = new WeakReference<LocalsRootNode>(localsRootNode);
            this.thread = localsRootNode.thread;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            LocalsRootNode localsRootNode = (LocalsRootNode)this.node.get();
            if (localsRootNode == null) {
                this.thread.removePropertyChangeListener(this);
                return;
            }
            if (propertyChangeEvent.getPropertyName() != null && propertyChangeEvent.getPropertyName().equals("variables")) {
                ((LocalsRootChildren)localsRootNode.getChildren()).changeChildren();
            }
        }
    }

    private static final class LocalsRootChildren
    extends Children.Keys
    implements LeafRefresher {
        private boolean init = false;

        private LocalsRootChildren() {
        }

        protected void addNotify() {
            this.init = true;
            this.changeChildren();
        }

        protected void removeNotify() {
            this.init = false;
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object object) {
            Node node = DebuggerNode.createNode(object, new Object[]{object, new Integer(1)});
            if (node == null) {
                return new Node[0];
            }
            return new Node[]{node};
        }

        void changeChildren() {
            if (!this.init) {
                return;
            }
            AbstractThread abstractThread = ((LocalsRootNode)this.getNode()).thread;
            if (abstractThread instanceof CallStackProducer) {
                Location[] locationArray = ((CallStackProducer)((Object)abstractThread)).getFilteredCallStack();
                if (locationArray.length > 0) {
                    Object[] objectArray = ((VariablesProducer)((Object)locationArray[0])).getVariablesFilter().getVariables((VariablesProducer)((Object)locationArray[0]));
                    Arrays.sort(objectArray, Utils.localsComparator);
                    this.setKeys(objectArray);
                } else {
                    this.setKeys(new AbstractVariable[0]);
                }
            }
        }

        public void refreshMyKey(Object object) {
            this.refreshKey(object);
        }
    }
}

