/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.nodes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.debugger.GUIManager;
import org.netbeans.modules.debugger.support.DebuggerContextSettings;
import org.netbeans.modules.debugger.support.View2;
import org.netbeans.modules.debugger.support.actions.DebuggerWindowPerformer;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.netbeans.modules.debugger.support.nodes.FilterToolbar;
import org.netbeans.modules.debugger.support.nodes.PropertiesView;
import org.netbeans.modules.debugger.support.nodes.ToolbarView;
import org.openide.actions.UndockAction;
import org.openide.awt.SplittedPanel;
import org.openide.explorer.ExplorerActions;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class DebuggerWindow
extends TopComponent {
    static final long serialVersionUID = 3943837264524812348L;
    private static final int SERIAL_VERSION = 1;
    public static final String PROP_VIEWS = "views";
    public static final String PROP_ORIENTATION = "orientation";
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    public static final int ALTERNATE = 3;
    private GUIManager.View[] views = new GUIManager.View[0];
    private ToolbarListener toolbarListener;
    private FListener fListener;
    private CListener cListener;
    private HashMap viewToComponent = new HashMap();
    private HashMap viewToListeners = new HashMap();
    private ToolbarView toolbar;
    private HashSet visibleViews;
    private ExplorerManager.Provider propertiesView;
    private TopComponent activatedTopComponent;
    private boolean initialized = false;
    private static DebuggerContextSettings dcSettings = null;
    private DCSettingsListener dcSettingsListener = null;
    private boolean vertical;
    private HashMap sizes = null;
    private int serSize = -1;
    private String workspace;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$nodes$DebuggerWindow;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$DebuggerContextSettings;

    public DebuggerWindow() {
        this.toolbarListener = new ToolbarListener();
        this.fListener = new FListener();
        this.cListener = new CListener();
        this.setName(DebuggerNode.getLocalizedString("CTL_Debugger_Window"));
        ((JComponent)((Object)this)).setToolTipText(DebuggerNode.getLocalizedString("CTL_Debugger_Window"));
        this.setIcon(new ImageIcon((class$org$netbeans$modules$debugger$support$nodes$DebuggerWindow == null ? (class$org$netbeans$modules$debugger$support$nodes$DebuggerWindow = DebuggerWindow.class$("org.netbeans.modules.debugger.support.nodes.DebuggerWindow")) : class$org$netbeans$modules$debugger$support$nodes$DebuggerWindow).getResource("/org/netbeans/core/resources/debuggerView.gif")).getImage());
        GUIManager.getDefault().addPropertyChangeListener(new GUIManagerListener(this));
        ((JComponent)((Object)this)).setPreferredSize(new Dimension(300, 490));
        DebuggerWindowPerformer.setDebuggerWindow(this);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.write(1);
        int n = this.views.length;
        if (this.initialized) {
            HashSet<GUIManager.View> hashSet = new HashSet<GUIManager.View>();
            HashMap<GUIManager.View, Integer> hashMap = new HashMap<GUIManager.View, Integer>();
            boolean bl = this.isVertical();
            int n2 = 0;
            while (n2 < n) {
                TopComponent topComponent;
                if (this.isVisible(this.views[n2])) {
                    hashSet.add(this.views[n2]);
                }
                if ((topComponent = (TopComponent)this.viewToComponent.get(this.views[n2])) != null) {
                    hashMap.put(this.views[n2], new Integer(bl ? topComponent.getSize().height : topComponent.getSize().width));
                }
                ++n2;
            }
            objectOutput.writeObject(hashSet);
            objectOutput.writeObject(hashMap);
            objectOutput.writeObject(new Integer(this.getDWSize()));
            objectOutput.writeObject(new Boolean(bl));
            objectOutput.writeObject(this.workspace);
        } else {
            objectOutput.writeObject(null);
            objectOutput.writeObject(null);
            objectOutput.writeObject(new Integer(-1));
            objectOutput.writeObject(Boolean.FALSE);
            objectOutput.writeObject("Debugging");
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        try {
            super.readExternal(objectInput);
            int n = objectInput.read();
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        this.visibleViews = (HashSet)objectInput.readObject();
        this.sizes = (HashMap)objectInput.readObject();
        this.serSize = (Integer)objectInput.readObject();
        this.vertical = (Boolean)objectInput.readObject();
        this.workspace = (String)objectInput.readObject();
        DebuggerWindow debuggerWindow = DebuggerWindowPerformer.getDebuggerWindow(this.workspace, this);
        if (debuggerWindow != this) {
            debuggerWindow.visibleViews = this.visibleViews;
            debuggerWindow.sizes = this.sizes;
            debuggerWindow.serSize = this.serSize;
            debuggerWindow.vertical = this.vertical;
            debuggerWindow.workspace = this.workspace;
            debuggerWindow.initialized = false;
        }
    }

    private Object readResolve() throws ObjectStreamException {
        DebuggerWindow debuggerWindow = DebuggerWindowPerformer.getDebuggerWindow(this.workspace, this);
        return debuggerWindow;
    }

    public void addNotify() {
        if (!this.initialized) {
            this.setViews(GUIManager.getDefault().getViews());
        }
        this.initialized = true;
        this.visibleViews = null;
        this.sizes = null;
        this.serSize = -1;
        ((Component)((Object)this)).enableEvents(101L);
        if (dcSettings == null) {
            dcSettings = (DebuggerContextSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$DebuggerContextSettings == null ? (class$org$netbeans$modules$debugger$support$DebuggerContextSettings = DebuggerWindow.class$("org.netbeans.modules.debugger.support.DebuggerContextSettings")) : class$org$netbeans$modules$debugger$support$DebuggerContextSettings), (boolean)true);
        }
        this.dcSettingsListener = new DCSettingsListener();
        dcSettings.addPropertyChangeListener(this.dcSettingsListener);
        super.addNotify();
        if (this.vertical != this.isVertical()) {
            this.showViews(this.getViews());
        }
    }

    public void removeNotify() {
        super.removeNotify();
        dcSettings.removePropertyChangeListener(this.dcSettingsListener);
        this.dcSettingsListener = null;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("debug.debugger.window");
    }

    private static int getOrientation() {
        if (dcSettings == null) {
            dcSettings = (DebuggerContextSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$DebuggerContextSettings == null ? (class$org$netbeans$modules$debugger$support$DebuggerContextSettings = DebuggerWindow.class$("org.netbeans.modules.debugger.support.DebuggerContextSettings")) : class$org$netbeans$modules$debugger$support$DebuggerContextSettings), (boolean)true);
        }
        return dcSettings.getDWOrientation();
    }

    private boolean isVertical() {
        if (this.serSize != -1) {
            return this.vertical;
        }
        return DebuggerWindow.getOrientation() == 3 ? 1.5 * ((Component)((Object)this)).getSize().getHeight() >= ((Component)((Object)this)).getSize().getWidth() : DebuggerWindow.getOrientation() == 2;
    }

    public TopComponent getComponent(GUIManager.View view) {
        return (TopComponent)this.viewToComponent.get(view);
    }

    public boolean isVisible(GUIManager.View view) {
        if (this.visibleViews != null) {
            return this.visibleViews.contains(view);
        }
        if (this.toolbar != null) {
            return this.toolbar.isVisible(view);
        }
        if (view instanceof View2) {
            return ((View2)view).isVisible();
        }
        return true;
    }

    public void setVisible(GUIManager.View view, boolean bl) {
        if (this.toolbar != null) {
            this.toolbar.setVisible(view, bl);
        }
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String string) {
        if (this.workspace != null) {
            throw new SecurityException("Workspace already set!");
        }
        this.workspace = string;
    }

    public GUIManager.View[] getViews() {
        return this.views;
    }

    public void addView(int n, GUIManager.View view) {
        if (this.views.length == 0) {
            this.setViews(new GUIManager.View[]{view});
            return;
        }
        GUIManager.View[] viewArray = new GUIManager.View[this.views.length + 1];
        if (n > 0) {
            System.arraycopy(this.views, 0, viewArray, 0, n);
        }
        if (n < this.views.length) {
            System.arraycopy(this.views, n, viewArray, n + 1, this.views.length - n);
        }
        viewArray[Math.min((int)n, (int)this.views.length)] = view;
        this.setViews(viewArray);
    }

    public boolean removeView(GUIManager.View view) {
        int n = this.views.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.views[n2] == view) {
                if (n == 1) {
                    this.setViews(new GUIManager.View[0]);
                } else {
                    GUIManager.View[] viewArray = new GUIManager.View[n - 1];
                    if (n2 > 0) {
                        System.arraycopy(this.views, 0, viewArray, 0, n2);
                    }
                    if (n2 < n - 1) {
                        System.arraycopy(this.views, n2 + 1, viewArray, n2, n - n2 - 1);
                    }
                    this.setViews(viewArray);
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setViews(GUIManager.View[] viewArray) {
        GUIManager.View[] viewArray2 = this.views;
        this.views = viewArray;
        if (viewArray.length == 0) {
            if (this.isOpened()) {
                this.setCloseOperation(0);
                this.close();
            }
        } else {
            this.showViews(this.views);
        }
        if (viewArray.length != 0 && !this.isOpened()) {
            this.setCloseOperation(1);
            this.open();
        }
        ((Component)((Object)this)).firePropertyChange(PROP_VIEWS, viewArray2, this.views);
    }

    private int getOldSize(GUIManager.View view, TopComponent topComponent) {
        if (this.sizes != null) {
            Integer n = (Integer)this.sizes.get(view);
            return n == null ? 0 : n;
        }
        return this.isVertical() ? topComponent.getSize().height : topComponent.getSize().width;
    }

    private int getDWSize() {
        if (this.serSize != -1) {
            return this.serSize;
        }
        return this.isVertical() ? ((Component)((Object)this)).getSize().height : ((Component)((Object)this)).getSize().width;
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        if (this.isVertical() != this.vertical) {
            this.setViews(this.views);
        }
        super.processComponentEvent(componentEvent);
    }

    private void showViews(GUIManager.View[] viewArray) {
        int n;
        int n2;
        ArrayList arrayList;
        Object object;
        Object object2;
        Object object3;
        int n3;
        Object object4 = this;
        ((Container)((Object)this)).setLayout(new BorderLayout(0, 0));
        ((Container)((Object)this)).removeAll();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        boolean bl = this.vertical;
        this.vertical = this.isVertical();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = viewArray.length;
        boolean bl2 = this.toolbar != null;
        int n9 = 0;
        while (n9 < n8) {
            block29: {
                Object object5;
                GUIManager.View view;
                block32: {
                    block30: {
                        block31: {
                            view = viewArray[n9];
                            if (!this.isVisible(view)) break block29;
                            object5 = (TopComponent)this.viewToComponent.get(view);
                            int n10 = n3 = object5 != null ? 1 : 0;
                            if (n3 == 0) break block30;
                            object3 = view.getComponent();
                            if (object3 != null) break block31;
                            this.viewToComponent.remove(view);
                            break block29;
                        }
                        if (object5.getClass() != object3.getClass()) {
                            ((Component)object3).setSize(((Component)object5).getSize());
                            object5 = object3;
                            this.initSpecialViews(view, (TopComponent)object5);
                            this.viewToComponent.put(view, object5);
                        }
                        break block32;
                    }
                    object5 = view.getComponent();
                    if (object5 == null) break block29;
                    this.initSpecialViews(view, (TopComponent)object5);
                    this.viewToComponent.put(view, object5);
                }
                if (!(view instanceof View2) || !((View2)view).hasFixedSize()) {
                    ++n4;
                    int n11 = this.getOldSize(view, (TopComponent)object5);
                    if (n11 > 0) {
                        n6 += n11;
                    } else {
                        ++n7;
                    }
                } else {
                    n5 += this.vertical ? ((JComponent)object5).getPreferredSize().height : ((JComponent)object5).getPreferredSize().width;
                }
            }
            ++n9;
        }
        int n12 = this.getDWSize();
        int n13 = n4 == 0 ? 0 : (n12 - n5) / n4;
        n5 += n13 * n7;
        n3 = 0;
        n9 = 0;
        while (n9 < n8) {
            object3 = viewArray[n9];
            if (this.isVisible((GUIManager.View)object3) && (object2 = (TopComponent)this.viewToComponent.remove(object3)) != null) {
                if (!((Component)object2).isVisible()) {
                    ((JComponent)object2).setVisible(true);
                }
                if (object2 instanceof ToolbarView) {
                    bl2 = false;
                    ((ToolbarView)object2).setOrientation(this.vertical ? 0 : 1);
                    if (this.visibleViews != null) {
                        ((Component)((Object)((ToolbarView)object2))).removePropertyChangeListener(this.toolbarListener);
                        ((ToolbarView)object2).setViews(this.views);
                        ((ToolbarView)object2).setVisible(this.visibleViews);
                        ((Container)((Object)((ToolbarView)object2))).addPropertyChangeListener(this.toolbarListener);
                    }
                }
                if (object2 instanceof FilterToolbar) {
                    ((FilterToolbar)((Object)object2)).setOrientation(this.vertical ? 0 : 1);
                }
                hashMap.put(object3, object2);
                if (object3 instanceof View2 && ((View2)object3).hasFixedSize()) {
                    ((Container)object4).add((Component)object2, this.vertical ? "North" : "West");
                    if (n9 < n8 - 1) {
                        object = new JPanel();
                        ((Container)object).setLayout(new BorderLayout(0, 0));
                        ((Container)object4).add((Component)object, "Center");
                        object4 = object;
                    }
                    n3 += this.getOldSize((GUIManager.View)object3, (TopComponent)object2);
                } else {
                    if (n4 <= 1) {
                        ((Container)object4).add((Component)object2, "Center");
                        if (n9 < n8 - 1) {
                            object = new JPanel();
                            ((Container)object).setLayout(new BorderLayout(0, 0));
                            ((Container)object4).add((Component)object, this.vertical ? "South" : "East");
                            object4 = object;
                        }
                    } else {
                        object = new JPanel();
                        ((Container)object).setLayout(new BorderLayout(0, 0));
                        arrayList = new SplittedPanel();
                        arrayList.setSplitType(this.vertical ? 1 : 2);
                        arrayList.setSplitAbsolute(false);
                        arrayList.setSwapPanesEnabled(false);
                        arrayList.setSplitTypeChangeEnabled(false);
                        n2 = this.getOldSize((GUIManager.View)object3, (TopComponent)object2);
                        if (n12 < 1 || bl != this.vertical) {
                            n = 100 / n4;
                        } else {
                            n2 = n2 < 1 ? n13 : n2 * (n12 - n5) / n6;
                            n = n2 * 100 / (n12 - n3);
                            n3 += n2;
                        }
                        arrayList.setSplitPosition(n);
                        ((Container)((Object)arrayList)).add((Component)object2, SplittedPanel.ADD_FIRST);
                        ((Container)((Object)arrayList)).add((Component)object, SplittedPanel.ADD_SECOND);
                        ((Container)object4).add((Component)((Object)arrayList), "Center");
                        object4 = object;
                    }
                    --n4;
                }
            }
            ++n9;
        }
        if (bl2) {
            ((Component)((Object)this.toolbar)).removePropertyChangeListener(this.toolbarListener);
            this.toolbar = null;
        }
        object3 = this.viewToComponent.keySet().iterator();
        while (object3.hasNext()) {
            Component component;
            object2 = (GUIManager.View)object3.next();
            object = this.viewToComponent.get(object2);
            if (object instanceof PropertiesView) {
                this.propertiesView = null;
                continue;
            }
            arrayList = (ArrayList)this.viewToListeners.remove(object2);
            if (arrayList == null) continue;
            n = arrayList.size();
            n2 = 0;
            while (n2 < n) {
                component = (Component)arrayList.get(n2);
                component.removeFocusListener(this.fListener);
                component.removeComponentListener(this.cListener);
                ++n2;
            }
            if (!(object instanceof ExplorerManager.Provider)) continue;
            component = (ExplorerManager.Provider)object;
            component.getExplorerManager().removePropertyChangeListener((PropertyChangeListener)this.fListener);
        }
        this.viewToComponent = hashMap;
        if (this.toolbar != null) {
            this.toolbar.setViews(this.views);
        }
        ((JComponent)((Object)this)).revalidate();
        ((Component)((Object)this)).repaint();
    }

    private void initSpecialViews(GUIManager.View view, TopComponent topComponent) {
        if (topComponent instanceof ToolbarView) {
            if (this.toolbar != null) {
                ((Component)((Object)this.toolbar)).removePropertyChangeListener(this.toolbarListener);
            }
            this.toolbar = (ToolbarView)topComponent;
            ((Container)((Object)this.toolbar)).addPropertyChangeListener(this.toolbarListener);
        } else if (topComponent instanceof PropertiesView) {
            this.propertiesView = (ExplorerManager.Provider)topComponent;
        } else if (topComponent instanceof ExplorerManager.Provider) {
            ArrayList arrayList = new ArrayList();
            DebuggerWindow.findFocusables((Container)topComponent, arrayList);
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                Component component = (Component)arrayList.get(n2);
                component.addFocusListener(this.fListener);
                ++n2;
            }
            this.viewToListeners.put(view, arrayList);
            ((ExplorerManager.Provider)topComponent).getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this.fListener);
        }
    }

    private static void findFocusables(Container container, ArrayList arrayList) {
        if (DebuggerWindow.isFocusTraversable(container)) {
            arrayList.add(container);
        }
        int n = container.getComponentCount();
        Component component = null;
        int n2 = 0;
        while (n2 < n) {
            component = container.getComponent(n2);
            if (DebuggerWindow.isFocusTraversable(component)) {
                arrayList.add(component);
            }
            if (component instanceof Container) {
                DebuggerWindow.findFocusables((Container)component, arrayList);
            }
            ++n2;
        }
    }

    private static boolean isFocusTraversable(Component component) {
        return component.isFocusTraversable();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class GUIManagerListener
    implements PropertyChangeListener {
        private WeakReference window;

        GUIManagerListener(DebuggerWindow debuggerWindow) {
            this.window = new WeakReference<DebuggerWindow>(debuggerWindow);
            GUIManager.getDefault().addPropertyChangeListener(this);
        }

        private DebuggerWindow getWindow() {
            DebuggerWindow debuggerWindow = (DebuggerWindow)((Object)this.window.get());
            if (debuggerWindow == null) {
                GUIManager.getDefault().removePropertyChangeListener(this);
            }
            return debuggerWindow;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() != DebuggerWindow.PROP_VIEWS) {
                return;
            }
            DebuggerWindow debuggerWindow = this.getWindow();
            if (debuggerWindow == null) {
                return;
            }
            debuggerWindow.setViews(GUIManager.getDefault().getViews());
        }
    }

    class UndockPerformer
    implements ActionPerformer {
        UndockPerformer() {
        }

        public void performAction(SystemAction systemAction) {
            Iterator iterator = DebuggerWindow.this.viewToComponent.keySet().iterator();
            GUIManager.View view = null;
            while (iterator.hasNext()) {
                view = (GUIManager.View)iterator.next();
                if (DebuggerWindow.this.viewToComponent.get(view) == DebuggerWindow.this.activatedTopComponent) break;
            }
            if (view == null) {
                return;
            }
            DebuggerWindow.this.viewToComponent.remove(view);
            DebuggerWindow.this.setVisible(view, false);
            DebuggerWindow.this.activatedTopComponent.open();
        }
    }

    private class CListener
    extends ComponentAdapter {
        private CListener() {
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
        }
    }

    private class FListener
    extends FocusAdapter
    implements PropertyChangeListener {
        private ExplorerActions explorerActions;
        private ExplorerManager explorerManager;
        private UndockAction undockAction = (UndockAction)SystemAction.get((Class)(class$org$openide$actions$UndockAction == null ? (class$org$openide$actions$UndockAction = FListener.class$("org.openide.actions.UndockAction")) : class$org$openide$actions$UndockAction));
        static /* synthetic */ Class class$org$openide$actions$UndockAction;

        FListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            Component component;
            Component component2 = component = (Component)focusEvent.getSource();
            while (!(component2 instanceof ExplorerManager.Provider)) {
                component2 = component2.getParent();
            }
            ExplorerManager explorerManager = ((ExplorerManager.Provider)component2).getExplorerManager();
            this.setContext(explorerManager);
            if (this.explorerActions == null) {
                this.explorerActions = new ExplorerActions();
            }
            if (this.explorerManager != null) {
                this.explorerActions.detach();
            }
            this.explorerManager = explorerManager;
            this.explorerActions.attach(this.explorerManager);
            this.explorerActions.setConfirmDelete(false);
            while (!(component2 instanceof TopComponent)) {
                component2 = component2.getParent();
            }
            DebuggerWindow.this.activatedTopComponent = (TopComponent)component2;
            this.undockAction.setActionPerformer((ActionPerformer)new UndockPerformer());
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ExplorerManager explorerManager = (ExplorerManager)propertyChangeEvent.getSource();
            if (explorerManager != this.explorerManager) {
                return;
            }
            this.setContext(explorerManager);
        }

        private void setContext(ExplorerManager explorerManager) {
            Node[] nodeArray = explorerManager.getSelectedNodes();
            DebuggerWindow.this.setActivatedNodes(nodeArray);
            if (DebuggerWindow.this.propertiesView != null) {
                try {
                    DebuggerWindow.this.propertiesView.getExplorerManager().setRootContext(explorerManager.getRootContext());
                    DebuggerWindow.this.propertiesView.getExplorerManager().setSelectedNodes(nodeArray);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private class ToolbarListener
    implements PropertyChangeListener {
        private ToolbarListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == null || propertyChangeEvent.getPropertyName() != "visible") {
                return;
            }
            DebuggerWindow.this.showViews(DebuggerWindow.this.getViews());
            DebuggerWindow.super.firePropertyChange(DebuggerWindow.PROP_VIEWS, null, null);
        }
    }

    private class DCSettingsListener
    implements PropertyChangeListener {
        private DCSettingsListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == null || propertyChangeEvent.getPropertyName() != "dwOrientation") {
                return;
            }
            DebuggerWindow.this.showViews(DebuggerWindow.this.getViews());
        }
    }
}

