/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.nodes;

import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.ResourceBundle;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.GUIManager;
import org.netbeans.modules.debugger.NodesRegistry;
import org.netbeans.modules.debugger.support.DebuggerAdapter;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.TopManager;
import org.openide.debugger.DebuggerNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;

public class DebuggerNode
extends AbstractNode {
    static final long serialVersionUID = 6394601904375687521L;
    public static final String PROP_SHOW_MESSAGES = "showMessages";
    public static final String PROP_SHOW_IN_EDITOR = "showInEditor";
    public static final String PROP_REMOTE_DEBUGGING = "remoteDebugging";
    public static final String PROP_TOTAL_MEMORY = "totalMemory";
    public static final String PROP_FREE_MEMORY = "freeMemory";
    public static final String PROP_SOURCE_PATH = "sourcePath";
    public static final String PROP_EXCEPTION_CATCH_LIST = "exceptionCatchList";
    public static final String PROP_DEBUGGER_STATE = "debuggerState";
    private static final String ICON_BASE = "/org/netbeans/core/resources/debugger";
    private static ResourceBundle bundle;
    private transient AbstractDebugger debugger;
    private transient DebuggerAdapter debuggerListener;
    private transient PropertyChangeListener topManagetListener;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$nodes$DebuggerNode;
    static /* synthetic */ Class class$java$lang$String;

    public static String getLocalizedString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$nodes$DebuggerNode == null ? (class$org$netbeans$modules$debugger$support$nodes$DebuggerNode = DebuggerNode.class$("org.netbeans.modules.debugger.support.nodes.DebuggerNode")) : class$org$netbeans$modules$debugger$support$nodes$DebuggerNode));
        }
        return bundle.getString(string);
    }

    public static Node createNode(Object object) {
        Node node = NodesRegistry.getNode(object);
        if (node == null) {
            try {
                node = new BeanNode(object);
            }
            catch (IntrospectionException introspectionException) {
                introspectionException.printStackTrace();
            }
        }
        return node;
    }

    public static Node createNode(Object object, Object[] objectArray) {
        Node node = NodesRegistry.getNode(object, objectArray);
        if (node == null) {
            try {
                node = new BeanNode(object);
            }
            catch (IntrospectionException introspectionException) {
                introspectionException.printStackTrace();
            }
        }
        return node;
    }

    public DebuggerNode() {
        super((Children)new DebuggerChildren());
        String string = DebuggerNode.getLocalizedString("CTL_Debugger");
        this.setDisplayName(string);
        this.setName(string);
        this.setShortDescription(DebuggerNode.getLocalizedString("HINT_Debugger"));
        this.setIconBase(ICON_BASE);
        this.initialize();
    }

    private void initialize() {
        this.createProperties();
        TopManager.getDefault().addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == null || !propertyChangeEvent.getPropertyName().equals("debugger")) {
                    return;
                }
                DebuggerNode.this.debuggerChanged();
            }
        }, (Object)TopManager.getDefault()));
        this.debuggerChanged();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerDebuggerNode");
    }

    protected void createProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        set.put(Utils.createProperty((Object)this, class$java$lang$String == null ? (class$java$lang$String = DebuggerNode.class$("java.lang.String")) : class$java$lang$String, PROP_DEBUGGER_STATE, DebuggerNode.getLocalizedString("PROP_debugger_state"), DebuggerNode.getLocalizedString("HINT_debugger_state"), "getDebuggerState", null));
        this.setSheet(sheet);
    }

    public String getDebuggerState() {
        if (this.debugger == null) {
            return "";
        }
        switch (this.debugger.getState()) {
            case 1: {
                return DebuggerNode.getLocalizedString("VAL_NotRrunning");
            }
            case 2: {
                return DebuggerNode.getLocalizedString("VAL_Starting");
            }
            case 3: {
                return DebuggerNode.getLocalizedString("VAL_Running");
            }
            case 4: {
                return DebuggerNode.getLocalizedString("VAL_Stopped");
            }
        }
        return "";
    }

    void debuggerStateChanged() {
        this.firePropertyChange(null, null, null);
    }

    void debuggerChanged() {
        if (this.debugger != null) {
            this.debugger.removeDebuggerListener(this.debuggerListener);
        }
        try {
            this.debugger = (AbstractDebugger)TopManager.getDefault().getDebugger();
        }
        catch (DebuggerNotFoundException debuggerNotFoundException) {
            // empty catch block
        }
        if (this.debugger == null) {
            return;
        }
        if (this.debuggerListener == null) {
            this.debuggerListener = new DebuggerAdapter(){

                public void debuggerStateChanged(int n) {
                    DebuggerNode.this.debuggerStateChanged();
                }
            };
        }
        this.debugger.addDebuggerListener(this.debuggerListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class DebuggerChildren
    extends Children.Keys {
        private DebuggerChildren() {
        }

        protected void addNotify() {
            Object[] objectArray = GUIManager.getDefault().getRootNodes();
            this.setKeys(objectArray);
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object object) {
            Node node = NodesRegistry.getNode((String)object, new Object[0]);
            if (node == null) {
                return new Node[0];
            }
            return new Node[]{node};
        }
    }
}

